
#include <math.h>
#include <assert.h>
#include <iostream.h>
#include <fstream.h>
#include <time.h>  // time()

#include "fxt.h"
#include "fxtaux.h"
#include "testaux.cc"


const int is = +1;

int
main()
{
    ulong r = 4;
    ulong c = 4;
    ulong n = r*c;

    double* fr = new double[n];  null( fr, n );
    double* fi = new double[n];  null( fi, n );

    double* gr = new double[n];  null( gr, n );
    double* gi = new double[n];  null( gi, n );


    //    r , c:
    fr[c* 1 + 1] = 1.0;

    ulong mrc = r<c?r:c;
    for (ulong k=0; k<mrc; ++k)
    {
        ulong t = k+c*k;  assert( t<n );
        fr[t] = 1.0+k;
        t =  c-k-1+c*k;  assert( t<n );
        fr[t] = -1.0-k;
    }

    copy(fr,gr,n);


    print_twodim("rein fr:",fr,r,c);
//    print_twodim("rein gr:",gr,r,c);

//    twodim_fft(fr,fi,r,c,is);

//    twodim_fht(fr,r,c);
//    slow_twodim_ht(fr,r,c);
    slow_twodim_convolution(fr,fr,r,c);
//    y_transform(fr,r,c);
    print_twodim("fft fr:",fr,r,c,1e-6);
//    print_twodim("fft gr:",gr,r,c);

//    ri_multiply(gr,gi,fr,fi,n);
//    twodim_fft(fr,fi,r,c,-is);
//    ri_multiply(fr,fi,n,1.0/n);

//    y_transform(fr,r,c);
//    slow_row_column_ht(fr,r,c);

//    twodim_fht(fr,r,c);
//    slow_twodim_ht(fr,r,c);
//    multiply(fr,n,1.0/n);
    slow_twodim_ft(gr,gi,r,c,is);
//    twodim_fft(gr,gi,r,c,is);
    ri_square(gr,gi,n);
    slow_twodim_ft(gr,gi,r,c,-is);
//    twodim_fft(gr,gi,r,c,-is);
    multiply(gr,n,1.0/n);
//    print_twodim("raus fr:",fr,r,c,1e-6);
    print_twodim("raus gr:",gr,r,c,1e-6);


    delete [] fr;
    delete [] fi;
    delete [] gr;
    delete [] gi;
    
    return 0;
}
//===========================================
