#include <math.h>
#include <assert.h>
#include <iostream.h>
#include <fstream.h>
#include <time.h>  // time()

#include "fxt.h"
#include "fxtaux.h"

#include "testaux.cc"


void
fat(Complex *f, ulong ldn, Complex *a)  // dif2
{
    ulong  n = (1<<ldn);

    for (ulong ldm=ldn; ldm>=1; --ldm)
    {
        const ulong m = (1<<ldm);            // m = 2^ldm
	const ulong mh = (m>>1);             // mh = m/2
        const ulong m4 = (mh>>1);
        const double phi0 = M_PI/mh;

        for (ulong r=0; r<n; r+=m)
        {
            for (ulong j=0; j<mh; ++j)
            {
                const ulong t1 = r+j;
                const ulong t2 = t1+mh;

                Complex u = f[t1];
		Complex v = f[t2];

                f[t1] = u+v;
                f[t2] = u-v;
            }

            Complex *p = f+r+mh;
            for (ulong j=1, k=mh-1; j<m4; ++j,--k)
//            for (ulong j=0; j<mh; ++j)
            {
//                double s,c;
//                sincos(phi0*j, &s, &c);

//                double pj = p[j]*c+p[k]*s;
//                double pk = p[j]*s-p[k]*c;
                Complex pj = p[j];
                Complex pk = p[k];

                p[j] = pj;
                p[k] = -pk;
            }
        }
//        cout << "ldm=" << ldm ;
//        print("",f,n);
    }

    revbin_permute(f,n);
}
//===========================================

void
fmt(Complex *f, ulong ldn, int is)
{
    const ulong  n = (1<<ldn);
    const double pi = is*M_PI;  // +- pi

    for (ulong ldm=ldn; ldm>=1; --ldm)
    {
        const ulong m = (1<<ldm);            // m = 2^ldm
	const ulong mh = (m>>1);             // mh = m/2

        const double phi = pi/(double)(mh);

        for (ulong j=0; j<mh; ++j)
        {
	    double s,c;
//            sincos(phi*(double, &s, &c)j);  // fft
//            c = 1; s = 0;                 // walsh
//            sincos(0.5*phi*(double, &s, &c)j);
//            c = 2; s = 0;
//            sincos(is*2.0*M_PI/n, &s, &c);
//            c = 1.0+2.0*j/m; s = 0;  // not mod 
            c = pow(2.0,1.0*n*j/m); s = 0;  // zt not mod
//            c = pow(2.0,1.0*j/m); s = 0;

//            double t = 1.0*(mh-j)/mh;  // \in [1,0)
//            c = 2*t-1;  s = 1-fabs(c);

            for (ulong r=0; r<n; r+=m)
            {
                const ulong t1 = r+j;
                const ulong t2 = t1+mh;
                Complex u = f[t1];
                Complex v = f[t2];
                f[t1] =  u+v;
                f[t2] = (u-v)*Complex(c,s);  //exp(+-2*i*pi*j/m);
//                f[t2] = (u+v)*Complex(c,s);
            }
        }
//        cout << "ldm=" << ldm << ":" << endl;
//        print("",f,n);
    }

    revbin_permute(f,n);
}
//===========================================


int
main(int argc, char **argv)
{    
    int is = +1; // ISIGN
    assert( (is==+1) || (is==-1) );

    ulong ldn = 4;
    if ( argc>1 )  ldn = atol(argv[1]);
    ulong  n = (1<<ldn);
//    ulong nh = n/2;

    Complex *f = new Complex[n];  null( f, n );
    ulong d = 1;
    if ( argc>2 )  d = atol(argv[2]);
    assert( d<n );
    cout << "d=" << d << endl;
//    f[d] = Complex(1,0);

    Complex *a = new Complex[n];  null( a, n );
//    Complex *a = new Complex[nh];  null( a, nh );
    Complex *z = new Complex[n];  null( z, n );
    Complex *u = new Complex[n];  null( u, n );

//    double c,s;
//    sincos(is*2.0*M_PI/n, &s, &c);
////    Complex r = Complex(c,s)*2.0;
//    Complex r = 2.0;
//    for (ulong k=0; k<n; ++k)
//    {
//        a[k] = pow(r,(double)k);
//    }

//    Complex g = Complex(-1,0);
//    for (ulong k=0; k<n; ++k)
//    {
//        double t = (double)((2*k)%n)/2;
//        a[k]     = Complex(t,0);        
////        a[nh+k] = 0;
////        a[nh+k] = g*a[k];
//    }
//    print("a",a,n);

//    copy(a,f,n);
//    copy(f,z,n);

    for (ulong k=0; k<n; ++k)
    {
        null(f,n);
        f[k] = 1;
        fmt(f,ldn,is);
//        fat(f,ldn,a);
        z[k] = f[d];
    }
    
    print("z",z,n);

//    c_multiply(f,n,1.0/sqrt(n));
//    print("f",f,n);

//    fft(a,ldn,is);
//    print("a",a,n);

//    for (ulong k=0; k<n; ++k)
//    {
//        Complex s = 0;
//        for (ulong x=0; x<n; ++x)
//        {
//            s += z[x]
//                * a[(x*k)%n]; // slow transform
////                * pow(r,(double)x*k);  // z-transform
//            u[k] = s;
//        }
//    }
//    copy(u,f,n);
//    print("slow",f,n);

//    for (ulong k=0; k<n; ++k)
//    {
//        Complex s = 0;
//        for (ulong x=0; x<nh; ++x)
//        {
//            ulong t = nh+x;
//            Complex e = z[x]+z[t];
//
//            if ( ! (k&1) )  // even
//                s += e*a[(x*k)%n]; // ok
//
//            if ( k&1 )  // odd
//            {
//                ulong j = (k>>1)<<1;
//                s += e*a[(x*(j+1))%n]; // ok
//            }
//
//            u[k] = s;
//        }
//    }

//    copy(u,z,n);
//    print("test",z,n);
//    for (ulong k=0; k<n; ++k)  z[k] -= f[k];
//    print("diff",z,n);

    return 0;
}
//===========================================
