
#include <iostream.h>
#include <math.h>
#include <stdlib.h>  // atol(), atof()

#include "modm.h"
#include "factor.h"



// set  bx=63; bm=bx-0.01; z=22;
// bin 63 0.01 22
// 
// bin 62 0.1 22 | grep '\*3^' | grep '\*5^' | grep '\*7[^0-9]'
// gives:
// 4320668380299264001 =2^40*3^2*5^3*7*499+1  =0x3bf6190000000001 bits=61.906
// 4327595303554252801 =2^40*3^3*5^2*7^3*17+1  =0x3c0eb50000000001 bits=61.9083
// 4403791459359129601 =2^40*3^2*5^2*7*2543+1  =0x3d1d690000000001 bits=61.9335
// 4424572229124096001 =2^40*3^2*5^3*7^2*73+1  =0x3d673d0000000001 bits=61.9402
// 4434962614006579201 =2^40*3^2*5^2*7*13*197+1  =0x3d8c270000000001 bits=61.9436
// 4507695308183961601 =2^40*3^2*5^2*7*19*137+1  =0x3e8e8d0000000001 bits=61.9671
// 4531939539576422401 =2^40*3^2*5^2*7*2617+1  =0x3ee4af0000000001 bits=61.9748
// 4594281848871321601 =2^40*3^2*5^2*7^2*379+1  =0x3fc22b0000000001 bits=61.9945
// 4526744347135180801 =2^41*3^2*5^2*7*1307+1  =0x3ed23a0000000001 bits=61.9732
// 4589086656430080001 =2^41*3^2*5^4*7*53+1  =0x3fafb60000000001 bits=61.9929
// 4343180880877977601 =2^42*3^3*5^2*7*11*19+1  =0x3c46140000000001 bits=61.9135
// 4481719345977753601 =2^42*3^2*5^2*7*647+1  =0x3e32440000000001 bits=61.9588
// 4557915501782630401 =2^43*3^2*5^2*7^2*47+1  =0x3f40f80000000001 bits=61.9831
// 4405523190172876801 =2^44*3^3*5^2*7*53+1  =0x3d23900000000001 bits=61.934


int
main(int argc, char **argv)
{
    int bx = 63;    // max bits: your data type, e.g. 63 or 64 bit 
    // default=63
    if ( argc>1 )  bx = atol(argv[1]);
    cout << " bx=" << bx << endl;

    // default1: 0.5 (pushing fft length)
    // default2: 0.01 (pushing modulus)
    // ... with 64 bit we are in heaven anyway 
    double bm = 0.01;  // min bits
    if ( argc>2 )  bm = atof(argv[2]);
    cout << " bm=bx-" << bm << endl;
    bm = bx - bm;

    // bits search range: 
    int z  = 23;    // bx-z >= log_2(reasonable fft length) 
    // default1 = 10,   default2=23 
    if ( argc>3 )  z = atol(argv[3]);
    cout << " z=" << z << endl;


    //    umod_t bx2 = 1ULL<<bx;  // max bits
    umod_t bm2 = (umod_t)pow(2,bm);  //  min bits
    //    umod_t z2  = 1ULL<<z;  // search range


    for (int r=bx-z; r<=bx; ++r)
    {
        cout << "  ---- r=" << r <<" : ----- \n";
        umod_t r2 = (1ULL<<r);

        umod_t ym = (umod_t)(ceil(bm2/r2)/2)*2-1;  // approx bm2/rx2
        if ( 0==(ym&1) )  ym=ym-1;  // must be odd

        for (umod_t y=ym; y<=(1ULL<<z); y+=2)
        {
            umod_t p = r2*y+1;
            double bits = log(1.0*p)/log(2.0);

            if ( bits>=bx ) break;

            if ( is_pseudoprime(p) )
            {
                if  ( bits>=bm )
                {
                    cout << p << " =2^" << r << "*" 
//                         << y 
                         << factorization(y) 
                         << "+1 "
                         << hex << " =0x" << p << dec 
                         << " bits=" << bits <<"\n";
                }
            }
        }
    }

    return 0;
}
//----------------------------------
