
#include <math.h>
#include <iostream.h>

//#include "image.h"
#include "mfft.h"
#include "modm.h"
#include "jjassert.h"
#include "fxt.h"

#include "testaux.cc"

//image & mod_mandel(uint m);


//image &
void
arith_table(int q)
{
    // q = 1,2,3 for add,mul,pow

    uint i,k,r;
    umod_t m = mod::modulus;

//    image &img = *new image(m,m); 

    switch ( q )
    {
    case 1:  cout << " ADDITION: \n";  break;
    case 2:  cout << " MULTIPLICATION: \n";  break;
    case 3:  cout << " POWERS: \n";  break;
    case 4:  cout << " ORDER: \n";  break;
    case 5:  cout << " POWER RESIDUES: \n";  break;
    default: assert(0);
    }

    cout << "    ";
    cout << "[order/exp]";
    for (i=0; i<m; ++i)
    {
        cout.width(3);
        cout << i;
    }
    cout << "\n";

    cout << "----";
    cout << "----";
    cout << "-------";
    for (i=0; i<m; ++i)  cout << "---";
    cout << "\n";

    for (i=0; i<m; ++i)
    {
        cout.width(3);
        cout << i << " ";

        mod x = i, y = i;
        r = order(x);

        cout << "[";
        cout.width(3);
        cout << r;
        cout << "/";
        cout.width(3);
        cout << (r?(m-1)/r:0);
        cout << "]: ";

        for (k=0; k<m; ++k)
        {
            long  z;
            switch ( q )
            {
            case 1:  z = (x+mod(k)).x;  break; // add (only semi exciting)
            case 2:  z = (x*mod(k)).x;  break; // mult
            case 3:  z = (pow(x,k)).x;  break; // pow
            case 4: // order
                {
                    z = 0;
                    if ( !i )  break;
                    long r = order(mod(i));
                    if ( !r )  break;
//                    long e = mod::maxorder/r;
                    if ( 1==gcd(r,k) )  z = r;
                    break;
                }
            case 5:  // pow res
                {
                    z = 0;
                    for (uint j=0; j<m; ++j)
                    {
                        if ( mod(i)==pow(mod(j),k) )
                        {
                            z = j;
                            goto dort;
                        }
                    }
                dort:
                    break;
                }
            default: assert(0);
            }

            cout.width(3);
            if ( 0!=z )  cout << z;
            else         cout << "   ";

//            img.putpixel(k,i,(uint)z);
        }
        cout << "\n";
    }
    
    cout << "\n";

//    return img;
}
//-------------------------------------------


int
main(int argc, char **argv)
{
    umod_t m = 35;
    if ( argc>1 )  m = atol(argv[1]);
    mod::reinit(m);
    mod::print_info();

    Complex *f = new Complex[m];
    for (ulong k=0; k<m; ++k)  f[k] = -1;
    for (ulong k=0; k<m; ++k)
    {
        f[k] = kronecker(k,m);
//        mod s = pow(mod((uint)k),2);  f[s.x] = +1;
    }
    f[0] = 0;
//    for (ulong k=1; k<m; ++k)  if ( f[k]==0 )  f[k] = -1;
    
//    ulong n = m;
//    print("f",f,n);

//    Complex t = 0;
//    for (ulong k=0; k<m; ++k)  t += f[k]*exp(Complex(0,2.0*M_PI*k/m));
//    cout << "t=" << t << "  t*t=" << t*t << endl;

//    slow_ft(f,n,+1);
////    for (ulong k=0; k<m; ++k)  f[k] *= sqrt(1.0/n);
//    print("f",f,n);



//    for (mod z=1; z!=0; ++z)
//    {
//        if ( gcd(z.x,m)!=1 )  continue;
//
//        cout << z << ": ";
//
//        mod i = inv(-z);
//        cout << "  i=" << i;
//
////        mod mi = -i;
////        cout << "  mi=" << mi;
//
//        cout << endl;
//    }

//    image & img = 
//        arith_table(4);
        arith_table(3);

//    image &img = mod_mandel(65);
//    img.log_scale(255);

//    img.lin_scale(255);

//    img.write_pgm_file("tmp.pgm");
//    img.write_ppm_file("tmp.ppm");


    return 0;
}
//-------------------------------------------
