
#include "copy.h"
#include "fxtdefs.h"


void
slow_complex_correlation(const double *wr, const double *wi,
                         double *fr, double *fi, ulong nu)
// _cyclic_ correlation
// (use zero padded data for usual co.)
// result in fr,fi
{
    long n = (long)nu;
    long k,k2,tau;

    double *rr = new double[2*n];
    double *ri = rr + n;

    for (tau=0; tau<n; ++tau)
    {
	double sr=0.0, si=0.0;

	for (k=0; k<n; ++k)
	{
             k2 = k+tau;
             if ( k2>=n )  k2-=n;

	     double ar = fr[k];
	     double ai = fi[k];

	     CMULT(wr[k2],wi[k2],ar,ai);

	     sr += ar;
             si += ai;
	}

        rr[tau] = sr;
        ri[tau] = si;
    }

    copy(rr, fr, n);
    copy(ri, fi, n);

    delete [] rr;
}
// ============== end ================


void
slow_complex_auto_correlation(double *fr, double *fi, ulong nu)
// _cyclic_ self-correlation
// (use zero padded data for usual co.)
{
    slow_complex_correlation(fr, fi, fr, fi, nu);
}
// ============== end ================
