
#include <math.h>

#include "copy.h"
#include "sincos.h"


void
slow_ht(double *f, ulong n)
//
// (slow) hartley transform
//
{
    double *res = new double[n];

    const double ph0 = 2.0*M_PI/n;
    for (ulong w=0; w<n; ++w)
    {
        double t=0.0;
        for (ulong k=0; k<n; ++k)
	{
            double c,s;
            sincos(ph0*k*w, &s, &c);
//            sincos(ph0*k*(w+sh, &s, &c));  // shifted ht
            t += ((c+s)*f[k]);;
	}
        res[w] = t;
    }

    copy(res, f, n);

    delete [] res;
}
// ================== end ================
