
#include "copy.h"
#include "fxt.h"


void
slow_twodim_ft(double *fr, double *fi, ulong r, ulong c, int is)
{
    ulong n = r*c;

    // ft over rows:
    for (ulong k=0; k<n; k+=c)  slow_ft(fr+k,fi+k,c,is);

    double *wr = new double[r];
    double *wi = new double[r];

    // ft over columns:
    for (ulong k=0; k<c; k++)
    {
        skip_copy(fr+k,wr,r,c);
        skip_copy(fi+k,wi,r,c);
        slow_ft(wr,wi,r,is);
        skip_copy_back(wr,fr+k,r,c);
        skip_copy_back(wi,fi+k,r,c);
    }

    delete [] wr;   
    delete [] wi;   
}
// =============== end =========== 
