
#include "revbinpermute.h"
#include "graypermute.h"


void
dit2_walsh_wak(double *f, ulong ldn)
//
// transform wrt. to walsh-kronecker basis (wak-functions)
// self-inverse
// same transform as dif2_walsh_wak()
{
    ulong n = (1<<(ulong)ldn);
    for (ulong ldm=1; ldm<=ldn; ++ldm)
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u+v;
                f[t2] = u-v;
            }
        }
    }
}
// ============= end ===============


void
dit2_walsh_wal(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the wal functions are sequency- ordered
// self-inverse
// same transform as dif2_walsh_wal()
{
    const ulong n=(1<<ldn);
//    gray_permute(f,n);
//    revbin_permute(f,n);
//    dit2_walsh_wak(f,ldn);

    // same as:
//    dit2_walsh_wak(f,ldn);
//    revbin_permute(f,n);
//    inverse_gray_permute(f,n);

    // this version saves the gray_permute():
    revbin_permute(f,n);
    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;
//            double *f2 = f+t2;
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
            // reverse(f2, mh); ==
            for (ulong i=r+mh,j=i+mh-1; i<j; ++i,--j)  swap(f[i], f[j]);
        }
    }
}
// ================= end ==================


void
dit2_walsh_pal(double *f, ulong ldn)
//
// transform wrt. to walsh-paley basis (pal-functions)
// self-inverse
// same transform as dif2_walsh_pal()
{
    ulong n=(1<<(ulong)ldn);
    revbin_permute(f,n);
    dit2_walsh_wak(f,ldn);
}
// ============= end ===============
