
#include "reverse.h"
#include "revbinpermute.h"


void
walsh_seq(double *f, ulong ldn)
// walsh transform wrt. the basis (sequency at end of lines, '*':=1, ' ':=-1)
// 0: [* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *] ( 0)
// 1: [* * * * * * * * * * * * * * * *                                ] ( 1)
// 2: [                * * * * * * * * * * * * * * * *                ] ( 2)
// 3: [* * * * * * * *                 * * * * * * * *                ] ( 3)
// 4: [        * * * * * * * *                 * * * * * * * *        ] ( 4)
// 5: [        * * * * * * * *         * * * *                 * * * *] ( 5)
// 6: [        * * * *         * * * * * * * *         * * * *        ] ( 6)
// 7: [* * * *         * * * *         * * * *         * * * *        ] ( 7)
// 8: [    * * * *         * * * *         * * * *         * * * *    ] ( 8)
// 9: [    * * * *         * * * *     * *         * * * *         * *] ( 9)
//10: [* *         * *     * * * *         * * * *     * *         * *] (10)
//11: [    * * * *     * *         * *     * * * *     * *         * *] (11)
//12: [    * *     * * * *     * *         * *     * * * *     * *    ] (12)
//13: [    * *     * * * *     * *     * *     * *         * *     * *] (13)
//14: [    * *     * *     * *     * * * *     * *     * *     * *    ] (14)
//15: [* *     * *     * *     * *     * *     * *     * *     * *    ] (15)
//16: [  * *     * *     * *     * *     * *     * *     * *     * *  ] (16)
//17: [  * *     * *     * *     * *   *     * *     * *     * *     *] (17)
//18: [*     * *     *   * *     * *     * *     * *   *     * *     *] (18)
//19: [  * *     * *   *     * *     *   * *     * *   *     * *     *] (19)
//20: [*     *   * *     * *   *     * *     *   * *     * *   *     *] (20)
//21: [*     *   * *     * *   *     *   * *   *     * *     *   * *  ] (21)
//22: [*     *   * *   *     *   * *     * *   *     *   * *   *     *] (22)
//23: [  * *   *     *   * *   *     *   * *   *     *   * *   *     *] (23)
//24: [  *   * *   *     *   * *   *     *   * *   *     *   * *   *  ] (24)
//25: [  *   * *   *     *   * *   *   *   *     *   * *   *     *   *] (25)
//26: [*   *     *   *   *   * *   *     *   * *   *   *   *     *   *] (26)
//27: [  *   * *   *   *   *     *   *   *   * *   *   *   *     *   *] (27)
//28: [  *   *   *   * *   *   *   *     *   *   *   * *   *   *   *  ] (28)
//29: [  *   *   *   * *   *   *   *   *   *   *   *     *   *   *   *] (29)
//30: [  *   *   *   *   *   *   *   * *   *   *   *   *   *   *   *  ] (30)
//31: [*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ] (31)
{
    const ulong n = (1<<ldn);

    for (ulong ldm=ldn; ldm>=1; --ldm) // dif
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = t1+mh;
            double *f1 = f+t1, *f2 = f+t2;
            reverse(f2, mh);
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
            reverse(f1, mh);
        }
    }
    revbin_permute(f,n);
}
// ================= end ==================

void
inverse_walsh_seq(double *f, ulong ldn)
// walsh transform wrt. the basis (sequency at end of lines, '*':=1, ' ':=-1)
// 0: [* *   *       *     *         *     *   * * *       *         *] (16)
// 1: [* *   *       *     *         * * *   *       * * *   * * * *  ] (15)
// 2: [* *   *       * * *   * * * *   * *   *       *     *         *] (16)
// 3: [* *   *       * * *   * * * *       *   * * *   * *   * * * *  ] (15)
// 4: [* *   * * * *   * *   *       *     *         * * *   *       *] (16)
// 5: [* *   * * * *   * *   *       * * *   * * * *       *   * * *  ] (15)
// 6: [* *   * * * *       *   * * *   * *   * * * *   * *   *       *] (16)
// 7: [* *   * * * *       *   * * *       *         *     *   * * *  ] (15)
// 8: [* * *   * *   *       * * *   *       *     *         * * *   *] (16)
// 9: [* * *   * *   *       * * *   * * * *   * *   * * * *       *  ] (15)
//10: [* * *   * *   * * * *       *   * * *   * *   *       * * *   *] (16)
//11: [* * *   * *   * * * *       *         *     *   * * *       *  ] (15)
//12: [* * *       *   * * *   * *   *       * * *   * * * *   * *   *] (16)
//13: [* * *       *   * * *   * *   * * * *       *         *     *  ] (15)
//14: [* * *       *         *     *   * * *       *   * * *   * *   *] (16)
//15: [* * *       *         *     *         * * *   *       *     *  ] (15)
//16: [*   * *   * * *   *       * * *   *     *         *       * * *] (16)
//17: [*   * *   * * *   *       * * * *   * *   * * * *   * * *      ] (15)
//18: [*   * *   * * * *   * * *       *   * *   * * *   *       * * *] (16)
//19: [*   * *   * * * *   * * *         *     *       *   * * *      ] (15)
//20: [*   * * *       *   * *   * * *   *       * * * *   * *   * * *] (16)
//21: [*   * * *       *   * *   * * * *   * * *         *     *      ] (15)
//22: [*   * * *         *     *       *   * * *       *   * *   * * *] (16)
//23: [*   * * *         *     *         *       * * *   *     *      ] (15)
//24: [*       *   * *   * * * *   * *   * * *   *       * * * *   * *] (16)
//25: [*       *   * *   * * * *   * * *       *   * * *         *    ] (15)
//26: [*       *   * * *         *     *       *   * *   * * * *   * *] (16)
//27: [*       *   * * *         *       * * *   *     *         *    ] (15)
//28: [*         *     *       *   * *   * * * *   * * *       *   * *] (16)
//29: [*         *     *       *   * * *         *       * * *   *    ] (15)
//30: [*         *       * * *   *     *         *     *       *   * *] (16)
//31: [*         *       * * *   *       * * * *   * *   * * *   *    ] (15)
//
{
    const ulong n = (1<<ldn);

    revbin_permute(f,n);
    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = t1+mh;
            double *f1 = f+t1, *f2 = f+t2;
            reverse(f2, mh);
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
            reverse(f1, mh);
        }
    }
}
// ================= end ==================
