
#include "waveletfilter.h"
#include "auxdouble.h" // norm()

//#include <math.h>
//#include <iostream.h>
#include <assert.h>


wavelet_filter::wavelet_filter(const double *w)
    : nwc(0), wvc(0), awvc(0)
{
    long i=0;
    while ( w[i]!=0 )  ++i;
    nwc = i;

    wvc = new double[nwc];
    awvc = new double[nwc];
    for (i=0; i<nwc; ++i)
    {
        wvc[i] = w[i];

        if ( !(i&1) )  awvc[nwc-1-i] = -wvc[i];
        else           awvc[nwc-1-i] = +wvc[i];
    }

    assert( 0==check() );
}
//-----------------------

wavelet_filter::~wavelet_filter()
{
    delete [] wvc;
    wvc = 0;

    delete [] awvc;
    awvc = 0;
}
//-----------------------

int
wavelet_filter::check() const
{
//    cout << "wavelet_filter(): nwc=" << nwc << endl;


//    for (i=0; i<nwc; ++i)  cout << "wavelet_filter(): wvc[" << i << "]=" << wvc[i] << endl;
//    for (i=0; i<nwc; ++i)  cout << "wavelet_filter(): awvc[" << i << "]=" << awvc[i] << endl;

    double v = norm(wvc,nwc); 
//    cout << "wavelet_filter(): norm=" << v << endl;
    if ( (fabs(v)-1.0)>1e-6 )  return -1;

    return 0;
}
//-----------------------


// haar:
static const double haar2[] =
{
    +sqrt(0.5),
    +sqrt(0.5),

    +0.0
};
//-----------------------

// test:
static const double test[] =
{
    +0.5,
    +0.5,
    -0.5,
    +0.5,

    +0.0
};
//-----------------------

// daub4:
// 0 == 256*x^4 - 192*x^2 + 9
// 0 == 256*x^4 - 64*x^2 + 1
static const double daub4[] =
{
    (1.0+sqrt(3.0))/(4.0*sqrt(2.0)), // +0.4829629131445341433748716
    (3.0+sqrt(3.0))/(4.0*sqrt(2.0)), // +0.8365163037378079055752937
    (3.0-sqrt(3.0))/(4.0*sqrt(2.0)), // +0.2241438680420133810259727
    (1.0-sqrt(3.0))/(4.0*sqrt(2.0)), // -0.1294095225512603811744494

    +0.0
};
//-----------------------


// daub6:
static const double daub6[] =
{
//    ((1.0+sqrt(10)+sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
//    ((5.0+sqrt(10)+3.0*sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
//    ((10.0-2.0*sqrt(10)+2.0*sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
//    ((10.0-2.0*sqrt(10)-2.0*sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
//    ((5.0+sqrt(10)-3.0*sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
//    ((1.0+sqrt(10)-sqrt(5.0+2.0*sqrt(10.0))) / (16.0*sqrt(2.0))) ,
// ==
    +0.3326705529500826159985115891390056300129,
    +0.8068915093110925764944936040887134905193,
    +0.4598775021184915700951519421476167208081,
    -0.1350110200102545886963899066993744805622,
    -0.08544127388202666169281916918177331153620,
    +0.03522629188570953660274066471551002932775,

    +0.0
};
//-----------------------


// daub8:
static const double daub8[] =
{
    +3.22231006040514678716159e-02,
    -1.26039672620313037539160e-02,
    -9.92195435766335325852080e-02,
    +2.97857795605306051402901e-01,
    +8.03738751805132080878805e-01,
    +4.97618667632774989979605e-01,
    -2.96355276460024917643691e-02,
    -7.57657147895022132277461e-02,
    
    +0.0
};
//-----------------------

// daub10:
static const double daub10[] =
{
    +1.95388827352498268e-02,
    -2.11018340246890410e-02,
    -1.75328089908056224e-01,
    +1.66021057645108481e-02,
    +6.33978963456792064e-01,
    +7.23407690404040792e-01,
    +1.99397533976855597e-01,
    -3.91342493023138436e-02,
    +2.95194909257062613e-02,
    +2.73330683449987688e-02,
    
    +0.0
};
//-----------------------



// daub12:
static const double daub12[] =
{
    -7.8007083250323804142e-03,
    +1.7677118642540077410e-03,
    +4.4724901770781384662e-02,
    -2.1060292512370847991e-02,
    -7.2637522786376583464e-02,
    +3.3792942172816583271e-01,
    +7.8764114102865099607e-01,
    +4.9105594192797373304e-01,
    -4.8311742585698054971e-02,
    -1.1799011114852002540e-01,
    +3.4907120842221625153e-03,
    +1.5404109327044824299e-02,

    //// from numerical recipes:  !only float prec!
    //    +0.111540743350,
    //    +0.494623890398,
    //    +0.751133908021,
    //    +0.315250351709,
    //    -0.226264693965,
    //    -0.129766867567,
    //    +0.097501605587,
    //    +0.027522865530,
    //    -0.031582039318,
    //    +0.000553842201,
    //    +0.004777257511,
    //    -0.001077301085,

    +0.0
};
//-----------------------

// daub20:
static const double daub20[] =
{
// from numerical recipes:  !only float prec!
    +0.026670057901,
    +0.188176800078,
    +0.527201188932,
    +0.688459039454,
    +0.281172343661,
    -0.249846424327,
    -0.195946274377,
    +0.127369340336,
    +0.093057364604,
    -0.071394147166,
    -0.029457536822,
    +0.033212674059,
    +0.003606553567,
    -0.010733175483,
    +0.001395351747,
    +0.001992405295,
    -0.000685856695,
    -0.000116466855,
    +0.000093588670,
    -0.000013264203,

    +0.0
};
//-----------------------


const wavelet_filter wf_test(test);
const wavelet_filter wf_haar2(haar2);
const wavelet_filter wf_daub4(daub4);
const wavelet_filter wf_daub6(daub6);
const wavelet_filter wf_daub8(daub8);
const wavelet_filter wf_daub10(daub10);
const wavelet_filter wf_daub12(daub12);
const wavelet_filter wf_daub20(daub20);
