//
// simple example 1:
// power computation and root extraction
//

#include <iostream.h>

#include  "../src/include/hfloat.h"
#include  "../src/fxt/mult/fxtmult.h"


int main()
{
    // precision in LIMBs, use o power of two:
    ulong prec = 4096;
    hfloat::default_prec(prec);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    // extract the r-th root of i:
    int    i = 3333;
    int    r = 4444;         // which root o extract
    hfloat a ,c;

    a = i;
    root(a,r,c);             // fct(src1,src2,dest);
    cout << "\n c = " << i << "**(1/" << r << ")";
    print(" = \n",c,12);   // omit last arg to get full precision

    // check result:
    a = c;
    pow(a,r,c);              // r-th power, should be =i
    cout << "\n c**" << r << " = (approx.=" << i << ")";
    print(" = \n",c,12);
    c -= i;                  // same as  'sub(c,i,c);'
    print("\n small= \n",c,12);  // hopefully close to zero

    long d = c.prec()+c.exp();
    cout << "\n i.e. in the computation using a total of " << c.prec()
         << " LIMBs \n   all but the last " << d
         << " LIMBs were correct " << endl;

    cout << endl;
    fxtmult::print_statistics(prec);

    return 0;
}
//---------------
