//
// simple example 2: 
// compute pi with 2 different algorithms
//

#include  "../src/include/hfloat.h"

#include <stdlib.h>  // atol()


int main(int argc, char **argv)
{
    // precision in LIMBs, use o power of two:
    ulong n = 2048;
    if ( argc>1 )  n = atol(argv[1]);
    hfloat::default_prec(n);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    hfloat pi1, pi2, d;

    // first pi computation:
    pi_4th_order(pi1);  // compute pi using borweins quartic algorithm
    print("\n pi1=\n", pi1, 44); // print the first 44 LIMBs of pi1 
    print_last("\n last digits are \n", pi1, 16); // print the last 16 LIMBs
    save("pi1.dat",pi1);  // save pi1 to file "pi1.dat"


    // second pi computation:
    pi_agm(pi2);  // compute pi using the agm algorithm

    /* // you can choose from these, cf. src/pi/pi*.cc:
    pi_4th_order(pi2, var);  // var = 0,1
    pi_5th_order(pi2);
    pi_agm(pi2,var);         // var = 0,1
    pi_agm3(pi2,var);        // var = +1,-1,+4,-4
    pi_2nd_order(pi2);
    pi_derived_agm(pi2);
    pi_3rd_order(pi2);
    pi_9th_order(pi2);
    pi_cubic_agm(pi2);
    pi_arctan(pi2, fno);     // fno = 2,3,4,5,6,7,11
    */

    print("\n pi2=\n", pi2, 44);
    print_last("\n last digits are \n", pi2, 16);
    save("pi2.dat",pi2);  // save pi2 to file "pi2.dat"

    d =  pi1;
    d -= pi2;

    cout << "\n\n decimal precision of the results is "
         << prec_convert(pi1.prec(),10) << " digits "
         << endl;

    print("\n difference of the results: p1-p2= \n",d,8);

    ulong dl;
    cmp(pi1, pi2, dl);
    dl = pi1.prec() - dl;

    cout << "\n i.e. the last " << dl << " LIMBs disagree " << endl;


    return 0;
}
//---------------
