//
// simple example 4: 
// golden ratio & extreme precisions
//

#include  "../src/include/hfloat.h"
#include  "../src/include/hfverbosity.h"

int
main()
{
    const ulong ppr = 20;  // how many LIMBs to print, 0 ==> full prec

    // precision in LIMBs, use o power of two:
    hfloat::default_prec(8*1024*1024);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);
   
    hfverbosity::tell_all();
    hfverbosity::tell_fxtmult();

    hfloat::print_info();

    hfloat a;
    hfloat b;
    // ----- golden ratio:
    isqrt(5,b);  // b=1/sqrt(5)
    a = b;
    a *= 5;      // a=sqrt(5)
    a += 1;
    a /= 2;      // a=(sqrt(5)+1)/2
    print("\n golden ratio= \n",a,ppr);
//    save("goldenratio.txt",a);

    // ----- check precision:   
    sqr(a,b);  b -= a;  b -= 1;  // b = a*a-a-1
    print(" 0.0 = approx = \n",b,ppr);
    cout << "b.prec()=" << b.prec() << endl;
    cout << " = " << prec_convert(b.prec(),10) << " dec. dig." << endl;

    return 0;
}
//---------------
