//
// simple example 5: 
// continued fraction of pi
//


#include  "../src/include/hfloat.h"


int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::default_prec(128);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    // ----- compute some constant:
    hfloat p,t;
    pi_4th_order(p);
    print("pi=",p);

    // uncomment for alternative constant:
//    t = 163;
//    sqrt(t,t);
//    t /= 3;
//    t *= p;
//    exp(t,t);
//    p = t;
//    print("exp(pi*sqrt(163)/9)=",p,32);
    

    // ----- compute continued fraction:
    ulong m = (ulong)(prec_convert(p.prec(),10)*0.96); // how many cf terms 
    long cf[m];

    hfloat_to_contfrac(p,m,cf);
    for (ulong k=0; k<m; ++k)  
    {
        cout << cf[k] << ", ";
        if ( k%10==0 ) cout << endl;
    }
    cout << endl;

    // ----- cont fract to hfloat:
    contfrac_to_hfloat(cf,m,t);
    t -= p;
    print("t-pi=",t,16);


    // a few ratios:
    contfrac_to_ratio(cf,5,p,t);  // 2.param max = m-1

    return 0;
}
//---------------
