//
// simple example 8: 
// bogo lucas lehmer test:
// p=2^q-1 prime <==> cosh(2^(q-2)*log(2+sqrt(3)))%p=0
//


#include  "../src/include/hfloat.h"
#include  "../src/include/hfverbosity.h"

#include <assert.h>

void
LL(ulong q, hfloat &x)
{
    x = 2;
    for (ulong k=0; k<q-2; ++k)
    {
        sqr(x,x);
        x *= 2;
        x -= 1;
    }   
}
//---------------


int main()
{
    hfverbosity::hush_all();

    // precision in LIMBs, use o power of two:
    hfloat::default_prec(1024);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(65536);

    ulong  q = 13;  // test 2**q-1,  try 13 (prime) and 14 (not prime)
    // 2,3,5,7,13,17,19,31,61,89,107,127,521,607
    cout << "q = " << q << endl;

    hfloat a, b, c, m;

    m = 1;
    mul2pow(m,q,m);
    m -= 1;
    print("mersenne=\n",m,10);

    sqrt(3,a);
    a += 2;
    print("2+sqrt(3)=\n",a);

    log(a,b);
    print("log(2+sqrt(3))=\n",b);

    mul2pow(b,q-2,c);
    print("2^(q-2)*log(2+sqrt(3))=\n",c);

//    cosh(c,a);  // a should be (very close to) an integer
//    print("cosh(...)=\n",a);

    exp(c,a);  a /= 2;  // a should be close to an integer
    print("exp(...)=\n",a);

    round(a,a);
    print("round()=\n",a);

    LL(q,b);
    print("== LL()=\n",b);

    a -= b;
    print("0 =?= a-b=\n",a,10);
    assert( a.is_zero() );

    fmod(b, m, b);
    print("fmod()=\n",b,10);

    round(b,b);
    print("round(fmod())=\n",b,10);

    if ( b!=0 )
    {
        b -= m;
        round(b,b);
        print("round(fmod())-m=\n",b,10);
    }

    print("mersenne=\n",m,10);
    if ( b==0 )  cout << "is PRIME." << endl;
    else         cout << "is NOT prime." << endl;

    return 0;
}
//---------------
