
#include "fxttypes.h"
#include "complextype.h"

#include <iostream.h>


#define CHOP(x,eps)  (fabs(x)<(eps) ? 0 : (x))

void
print(const char *bla, const double *f, ulong n, double eps/*=0.0*/)
{
    cout << endl;
    if ( bla )  cout << bla << endl;

    for (ulong k=0; k<n; ++k)
    {
        double r = f[k];
        if ( eps!=0.0 )  r = CHOP(r,eps);

        cout.width(8);
        cout << r;
        cout << endl;
    }
    cout << endl;
}
//-----------------------


void
print_twodim(const char *bla, const double *f, ulong r, ulong c, double eps/*=0.0*/)
{
    cout << endl;
    if ( bla )  cout << bla << endl;

    for (ulong k=0; k<r; ++k)
    {
        cout.width(2);
        cout << k << ":  ";
        for (ulong j=0; j<c; ++j)
        {
            double r = f[j+k*c];
            if ( eps!=0.0 )  r = CHOP(r,eps);
            cout.width(8);
            cout << r;
        }
        cout << endl;
    }
}
//===========================================


void
c_print(const char *bla, const Complex *c, long n, double eps/*=0.0*/)
{
    cout << endl;
    if ( bla )  cout << bla << endl;

    for (long k=0; k<n; ++k)
    {
        double r = c[k].real();
        double i = c[k].imag();

        if ( eps!=0.0 )
        {
            r = CHOP(r,eps);
            i = CHOP(i,eps);
        }

        cout.width(8);
        cout << r;
        cout.width(8);
        cout << " + i* " << i << endl;
    }
    cout << endl;
}
//-----------------------


void
ri_print(const char *bla, const double *fr, const double *fi,
         long n, double eps/*=0.0*/)
{
    cout << endl;
    if ( bla )  cout << bla << endl;

    for (long k=0; k<n; ++k)
    {
        double r = fr[k];
        double i = fi[k];

        if ( eps!=0.0 )
        {
            r = CHOP(r,eps);
            i = CHOP(i,eps);
        }

        cout.width(8);
        cout << r;
        cout.width(8);
        cout << " + i* " << i << endl;
    }
    cout << endl;
}
//-----------------------


static int
print_approx_eq(const double *f, const double *g, uint n,
          int skip, double eps)
//
// for debugging
//
{
#define  CHOPX(x)  CHOP(x,1e-6)
    int failq = 0;
    for (uint i=0, j=0;  i<n;  i+=skip, ++j)
    {
        int di = 0;
        double d = f[i]-g[i];
        if ( fabs(d)>eps )  di = 1;
        if ( di )  failq = 1;
        cout.width(12);
//        if ( di )
        cout << CHOPX(d);
//        else cout << "            ";
        cout << "       =  ";
        cout.width(12);  cout << CHOPX(f[i]);
        cout << (di ? "  -**" : "  -  ");
        cout << "[";  cout.width(2);  cout << j << "]";
        cout << (di ? "**-  " : "  -  ");
        cout.width(12);  cout << CHOPX(g[i]);
//        if ( di )
        {
//            cout << "   yuck  ";
            cout.width(12);
            cout << CHOPX(f[i]+g[i]);
            cout.width(12);
            if ( CHOPX(f[i])!=0 && CHOPX(g[i])!=0 )  cout << g[i]/f[i];
        }
        cout << " " << endl;
    }
    return failq;
}
//-----------------------

void
approx_eq(const double *f, const double *g, uint n,
          const char *bla, double eps/*=1e-12*/)
//
// for debugging
//
{
    cout << bla << ": " << endl;
    int failq = print_approx_eq(f, g, n, 1, eps);
    
    cout << (failq ? " *** !ERROR! *** " : "OK.") << endl;
}
// =================== end ===================

void
approx_eq(const Complex *f, const Complex *g, uint n,
          const char *bla, double eps/*=1e-12*/)
//
// for debugging
//
{
    cout << bla << ": " << endl;

    int failq = 0;

    cout << " real: " << endl;
    failq |= print_approx_eq((double *)f, (double *)g, n, 2, eps);

    cout << " imag: " << endl;
    failq |= print_approx_eq((double *)f+1, (double *)g+1, n, 2, eps);

}
// =================== end ===================
