#if !defined __SCANBOX_H
#define      __SCANBOX_H


#include "fxttypes.h"
#include "misc.h"  // get_sum()


template <typename Type>
ulong
first_ge_sumbox_idx(const Type *f, ulong n, Type v, ulong boxlen)
// finds first box of length boxlen
// for which sum of the elements is >=v
// returns index of first element of that box
// returns n if no such box is found
{
    if ( 1==boxlen )  return first_ge_idx(f,n,v);

    if ( boxlen>=n )
    {
        if ( get_sum(f,n)>=v )  return 0;
        else                    return n;
    }

    ulong i;
    double bv = 0;
    for (i=0; i<boxlen; ++i)  bv += f[i];
    if ( bv>=v )  return i;

    for (  ; i<=n-boxlen; ++i)
    {
        bv = bv - f[i-1] + f[i+boxlen-1];  // value of box[i]  
        if ( bv>=v )  return i;
    }

    return n;
}
//-----------------------


template <typename Type>
ulong
last_ge_sumbox_idx(const Type *f, ulong n, Type v, ulong boxlen)
// finds last box of length boxlen
// for which sum of the elements is >=v
// returns index of first element of that box
// returns n if no such box is found
// add boxlen-1 to the result to get end of the box
{
    if ( boxlen==1 )  return last_ge_idx(f,n,v);

    if ( boxlen>=n )
    {
        if ( get_sum(f,n)>=v )  return 0;
        else                    return n;
    }

    ulong i;
    double bv = 0;
    for (i=n-1; i>=n-boxlen; --i)  bv += f[i];
    if ( bv>=v )  return i;

    do
    {
        bv = bv + f[i] - f[i+boxlen];  // value of box[i]  
        if ( bv>=v )  return i;
        --i;
    }
    while ( i );

    return n;
}
//-----------------------


template <typename Type>
ulong
first_le_sumbox_idx(const Type *f, ulong n, Type v, ulong boxlen)
// finds first box of length boxlen
// for which sum of the elements is <=v
// returns index of first element of that box
// returns n if no such box is found
{
    if ( boxlen==1 )  return first_le_idx(f,n,v);

    if ( boxlen>=n )
    {
        if ( get_sum(f,n)<=v )  return 0;
        else                    return n;
    }

    ulong i;
    double bv = 0;
    for (i=0; i<boxlen; ++i)  bv += f[i];
    if ( bv<=v )  return i;

    for (  ; i<=n-boxlen; ++i)
    {
        bv = bv - f[i-1] + f[i+boxlen-1];  // value of box[i]  
        if ( bv<=v )  return i;
    }

    return n;
}
//-----------------------

template <typename Type>
ulong
last_le_sumbox_idx(const Type *f, ulong n, Type v, ulong boxlen)
// finds last box of length boxlen
// for which sum of the elements is <=v
// returns index of first element of that box
// returns n if no such box is found
// add boxlen-1 to the result to get end of the box
{
    if ( boxlen==1 )  return last_ge_idx(f,n,v);

    if ( boxlen>=n )
    {
        if ( get_sum(f,n)<=v )  return 0;
        else                    return n;
    }

    ulong i;
    double bv = 0;
    for (i=n-1; i>=n-boxlen; --i)  bv += f[i];
    if ( bv<=v )  return i;

    do
    {
        bv = bv + f[i] - f[i+boxlen];  // value of box[i]  
        if ( bv<=v )  return i;
        --i;
    }
    while ( i );

    return n;
}
//-----------------------


#endif // !defined __SCANBOX_H
