#if !defined  __SINCOS_H
#define       __SINCOS_H

#include <math.h>


#define  SINCOS_AUTOMATIC  // undefine to select sincos by hand
//
// uncomment the above to manually choose one of:
//
#if !defined  SINCOS_AUTOMATIC
//#define  SINCOS_USE_TEMPL       // x86 asm template sincos
//#define  SINCOS_USE_FPU         // x86 asm sincos
//#define  SINCOS_USE_MATHINLINE  // inline-math sincos
//#define  SINCOS_USE_C           // plain call of sin() and cos()
#endif


#if defined SINCOS_AUTOMATIC

#if defined  __i386__  // if x86 cpu >= 386

#if defined  __GNUC__  // if GNU-C
// choose (uncomment) one of the next two lines:
#define  SINCOS_USE_TEMPL  // use x86 asm template, best choice
//#define  SINCOS_USE_FPU    // use x86 FPU asm code in sincos.cc
#endif // __GNUC__

#else // __i386__

// if __sincos_code is defined in /usr/include/bits/mathinline.h
#if defined  __sincos_code
#define  SINCOS_USE_MATHINLINE
#else  // __sincos_code
#define  SINCOS_USE_C  // use C-version
#endif // __sincos_code

#endif // __i386__

#else // SINCOS_AUTOMATIC
// ... algorithm selected by hand
#endif // SINCOS_AUTOMATIC



#if defined  SINCOS_USE_TEMPL
#define sincos(a,s,c) \
asm("fld %2; fsincos; fstpl %0; fstpl %1" \
    : "=m" (*((c))), "=m" (*((s))) \
    : "f" ((a)))
#endif // SINCOS_USE_TEMPL


#if defined  SINCOS_USE_FPU
// sincos.cc:
void sincos(double a, double *c, double *s);
#endif // SINCOS_USE_FPU


#if defined  SINCOS_USE_MATHINLINE
#define  sincos(a,s,c)  __sincos(a,s,c)
#endif // SINCOS_USE_MATHINLINE


#if defined  SINCOS_USE_C
inline void
sincos(double a, double *s, double *c)
{
    *s = sin(a);
    *c = cos(a);
}
#endif // SINCOS_USE_C



#endif  // __SINCOS_H
