#if !defined __REVERSE2D_H
#define      __REVERSE2D_H

#include "fxttypes.h"
#include "copy.h"  // swap(*,*,n)


template <typename Type>
void
reverse_horiz(Type **f, ulong nr, ulong nc)
// reverse order of rows
{
    while ( nr-- )  reverse(f[nr],nc);
}
//-----------------------


template <typename Type>
void
reverse_vert(Type **f, ulong nr, ulong nc)
// reverse order of rows
{
    ulong nh = nr/2;
    if ( 0==nh )  return;
    if ( nr&1 )  nh += 1;  // n odd

    for (ulong k=0, i=nr-1; k<nh; ++k,--i)
    {
        swap(f[k], f[i], nc);  // swap(row[#k], row[#i]);
    }
}
//-----------------------

#endif // !defined __REVERSE2D_H
