
#include <math.h>

#include "sincos.h"
#include "fxttypes.h"

void
make_fft_chirp(double *wr, double *wi, ulong n, int is)
//
// for k=0..n-1:
// Complex(wr[k],wi[k]) == exp(sqrt(-1)*k*k*ph0/2)
// for k=n..nn-1:
// Complex(wr[k],wi[k]) == (0,0)
//
{
    double phi = is*2.0*M_PI/n;

//    for (k=0; k<nn; ++k)  wr[k]=wi[k]=0.0;

//    // rest is equivalent to:
//    make_fft_fract_chirp(wr,wi,phi,n);
    
    phi *= 0.5;

    ulong n2 = 2*n;
    for (ulong np=0,k=0; k<n; ++k)
    {
        double c,s;

//        ulong k2 = (double)k*k;
//        sincos(phi*k2, &s, &c);
//  possible loss of precision due to huge arguments in sincos

        sincos(phi*np, &s, &c);

        np += ((k<<1)+1);  // np == (k*k)%n2

        if ( np>=n2 )  np -= n2;

        wr[k] = c;
        wi[k] = s;
    }
}
// ============== end ================ 


void
complete_fft_chirp(double *wr, double *wi, ulong n, ulong nn)
//
// exp(sqrt(-1)*pi*k*k/n) for k>=n :
// k==n+j, k*k==n*n+2*j*n+j*j
// exp(sqrt(-1)*pi/n*k*k)==exp(+-sqrt(-1)*pi*j*j/n)
// with plus for n even, minus for n odd
//
{
    if ( n&1 )  // n odd
    {
	for (ulong k=n; k<nn; ++k)  wr[k] = -wr[k-n];
	for (ulong k=n; k<nn; ++k)  wi[k] = -wi[k-n];
    }
    else
    {
	for (ulong k=n; k<nn; ++k)  wr[k] = wr[k-n];
	for (ulong k=n; k<nn; ++k)  wi[k] = wi[k-n];
    }
}
// ============== end ================ 



void
make_fft_fract_chirp(double *wr, double *wi, double v, ulong n, ulong nn)
//
// for k=0..nn:
// Complex(wr[k],wi[k]) == exp(sqrt(-1)*k*k*2*pi*/n/2)
//
{
    const double phi = v*2.0*M_PI/n/2;

    ulong n2 = 2*n;
    ulong np=0;
    for (ulong k=0; k<nn; ++k)
    {
        double c,s;
//        sincos(phi*k*k, &s, &c);
//  possible loss of precision due to huge arguments in sincos

        sincos(phi*np, &s, &c);
        np += ((k<<1)+1);  // np == (k*k)%n2
        if ( np>=n2 )  np -= n2;

        wr[k] = c;
        wi[k] = s;
    }
}
// ============== end ================

