
#include "fxt.h"
#include "shift.h"
#include "fxtdefs.h"
#include "evenoddrevpermute.h"


#define  SAVE_F0   1  // 0 or 1 (to keep the value f[0])
void
dst(double *f, ulong ldn, double *tmp/*=0*/)
// basis: sin(k*i*M_PI/n)
// self-inverse
{
    ulong n = (1<<(ulong)ldn);

#if  ( SAVE_F0!=0 )
    double f0 = f[0] * sqrt(n);
#endif

    f[0] = 0.0;
    f[n/2] *= 2.0;
    double phi = M_PI/n;
    for (ulong i=1,j=n-1; i<j; ++i,--j)
    {
        double s, d;
        SUMDIFF4(f[i], f[j], s, d);
        s *= sin(phi*i);
        d *= 0.5;
        SUMDIFF4(s, d, f[i], f[j]);
    }

    fht(f, ldn);
    const ulong nh = (n>>1);
    for (ulong i=1,j=n-1; i<nh; i++,j--)  SUMDIFF2_05(f[i], f[j]);

    f[0] *= 0.5;
    f[n/2] = 0.0;
    double s = 0;
    for (ulong i=0; i<n/2; ++i)
    {
        s += f[i];
        f[i] = s;
    }

    if ( tmp )
    {
        evenoddrev_permute(f, tmp, n);
        for (ulong k=n-1; k!=0; --k)  f[k] = tmp[k-1];
        f[0] = 0;
    }
    else
    {
        evenoddrev_permute(f, n);
        shift_right(f, n, 1);
    }
    
#if  ( SAVE_F0!=0 )
    f[0] = f0;
#endif
}
// ============= end ===============

