
#include "fxt.h"
#include "fxtdefs.h"  // SUMDIFF, CSQR, CMULT

#define  FHT_FFT_VERSION  0  // 0 or 1, doesn't matter

void
fht_fft(Complex *f, ulong ldn, int is)
// fft based on fht
{
#if  ( FHT_FFT_VERSION==1 )
    fht_fft_pre_processing(f, ldn, is);
    fht(f, ldn);
#else // FHT_FFT_VERSION
// alternative version, else same as fht_fft():
    fht(f, ldn);
    fht_fft_post_processing(f, ldn, is);
#endif // FHT_FFT_VERSION
}
// =================== end ===================


void
fht_fft0(Complex *f, ulong ldn, int is)
// fft based on fht
// version for zero padded data
{
    fht0(f, ldn);
    fht_fft_post_processing(f, ldn, is);
}
// ==================== end ===================


void
fht_fft_pre_processing(Complex *f, ulong ldn, int is)
// preprocessing to one length-n (complex) fht
// to compute a length-n complex fft
{
    const ulong n = (1<<ldn);
    double *fr = (double *)f;
    double *fi = fr + 1;
    if ( is>0 )
    {
        for (ulong i2=2, j2=2*(n-1);  i2<j2;  i2+=2, j2-=2)
        {
            double q, r, s, t;
            SUMDIFF4(fr[i2], fr[j2], q, r);
            SUMDIFF4(fi[i2], fi[j2], s, t);
            SUMDIFF4_05(q, t, fr[j2], fr[i2]);
            SUMDIFF4_05(s, r, fi[i2], fi[j2]);
        }
    }
    else  // r,t negated
    {
        for (ulong i2=2, j2=2*(n-1);  i2<j2;  i2+=2, j2-=2)
        {
            double q, r, s, t;
            SUMDIFF4(fr[j2], fr[i2], q, r);
            SUMDIFF4(fi[j2], fi[i2], s, t);
            SUMDIFF4_05(q, t, fr[j2], fr[i2]);
            SUMDIFF4_05(s, r, fi[i2], fi[j2]);
        }
    }
}
// ================== end ===================

void
fht_fft_post_processing(Complex *f, ulong ldn, int is)
// postprocessing to one length-n (complex) fht
// to compute a length-n complex fft
{
    const ulong n = (1<<ldn);
    double *fr = (double *)f;
    double *fi = fr + 1;
    if ( is>0 )
    {
        for (ulong i2=2, j2=2*(n-1);  i2<j2;  i2+=2, j2-=2)
        {
            double q, r, s, t;
            SUMDIFF4(fr[i2], fr[j2], q, r);
            SUMDIFF4(fi[i2], fi[j2], s, t);
            SUMDIFF4_05(q, t, fr[j2], fr[i2]);
            SUMDIFF4_05(s, r, fi[i2], fi[j2]);
        }
    }
    else  // r,t negated
    {
        for (ulong i2=2, j2=2*(n-1);  i2<j2;  i2+=2, j2-=2)
        {
            double q, r, s, t;
            SUMDIFF4(fr[j2], fr[i2], q, r);
            SUMDIFF4(fi[j2], fi[i2], s, t);
            SUMDIFF4_05(q, t, fr[j2], fr[i2]);
            SUMDIFF4_05(s, r, fi[i2], fi[j2]);
        }
    }
}
// ================== end ===================
