
#include "fxttypes.h"
#include "sincos.h" // sincos()

#include <math.h>


void
hartley_shift_05(double *a, ulong n)
//
// hartley analogue to fourier_shift(a,n,0.5)
// used for negacyclic convolution
// and recursive (radix 2) fhts
//
{
    const double phi0 = M_PI/n;
    const ulong nh = (n>>1);
    for (ulong i=1, j=n-1; i<nh; ++i,--j)
    {
        double s,c;
        sincos(phi0*i, &s, &c);
        double ai = a[i],  aj = a[j];
        a[i] = ai * c + aj * s;
        a[j] = ai * s - aj * c;
    }
}
// =========== end  ===========
