
#include "auxbit.h"
#include "fxt.h"


#define FHT(f,ldn)  fht(f,ldn)


void
row_column_fht(double *f, ulong r, ulong c)
// fht over rows and columns
// this is _not_ a two dimensional fht
{
    ulong n = r*c;

    // fht over rows:
    ulong ldc = ld(c);
    for (ulong k=0; k<n; k+=c)  FHT(f+k, ldc);

    double *w = new double[r];

    // fht over columns:
    for (ulong k=0; k<c; k++)  skip_fht(f+k, r, c, w);
    
    delete [] w;
}
// =============== end =========== 


void
y_transform(double *f, ulong r, ulong c)
// transforms row-column-fht to 2dim fht
// self-inverse
{
    ulong rh = r/2;
    if ( r&1 )  rh++;
    
    ulong ch = c/2;
    if ( c&1 )  ch++;

    ulong n = r*c;
    for (ulong tr=1, ctr=c; tr<rh; tr++,ctr+=c) // ctr=c*tr
    {
        double *pa = f + ctr;
        double *pb = pa + c;
        double *pc = f + n - ctr;
        double *pd = pc + c;
        for (ulong tc=1; tc<ch; tc++)
        {
            pa++;
            pb--;
            pc++;
            pd--;
            double e = (*pa + *pd - *pb - *pc) * 0.5;
            *pa -= e;
            *pb += e;
            *pc += e;
            *pd -= e;
        }
    }
}
//===========================================


void
twodim_fht(double *f, ulong r, ulong c)
// two dimensional fast hartley transform
{
    row_column_fht(f, r, c);
    y_transform(f, r, c);
}
// =============== end ===========
