
#include <iostream.h>
#include <stdio.h>  // sprintf

#include "fxtaux.h"
#include "auxgen.h"
#include "mod/modm.h"  // gcd

ulong mct, act;
double *st;

//#define  USE_GP  // else use bc

void
prsincos(char *varc, char *vars, long num, ulong den)
{
    const char f[] =
#ifdef  USE_GP
        "echo -e 'default(realprecision,30):  %s(Pi*%lu/%lu)' | gp -q | tr -d '\\\n'";
#else
        "echo -e 'scale=30;  %s(4*a(1)*%lu/%lu)' | bc -l | tr -d '\\\n'";
#endif
//    cerr << "f=" << f << endl;
    char str[128];
    cout << "double " << varc << "=" << flush;

    ulong nu = (num>0 ? num : -num);
    ulong g = gcd(nu, den);
    long nr = num/g,  dr = den/g;

    if ( 0==num )  cout << 1;
    else
    {
#ifdef  USE_GP
        sprintf(str,f,"cos",num,den);
#else
        sprintf(str,f,"c",num,den);
#endif
//    cerr << "str=" << str << endl;
        system(str);
    }
    cout << "; //";
    cout << " == cos(Pi*" << num << "/" << den << ")"
         << " == cos(Pi*" << nr << "/" << dr << ")"
         << endl;

    cout << "double " << vars << "=" << flush;
    if ( 0==num )  cout << 0;
    else
    {
#ifdef  USE_GP
        sprintf(str,f,"sin",num,den);
#else
        sprintf(str,f,"s",num,den);
#endif
        //    cerr << "str=" << str << endl;
        system(str);
    }
    cout << "; //";
    cout << " == sin(Pi*" << num << "/" << den << ")"
         << " == sin(Pi*" << nr << "/" << dr << ")"
         << endl;
}
// ===================== end =====================


void
prelude(ulong n, const char *fname, int scrt)
{
    st = new double[n];
    for (ulong i=0; i<n; ++i)  st[i] = i;

//    cout<<"#include <math.h>"<<endl;
//    cout<<endl;
//    cout<<"#include \"fxt.h\""<<endl;
//    cout<<"#include \"fxtaux.h\""<<endl;
//    cout<<"#include \"fxtdefs.h\""<<endl;
    cout<<endl;

//    cout<<"void"<<endl;
    cout<<fname;
    cout << "\n// unrolled version for length "<<n<<endl;
    cout<<"{"<<endl;

//    if ( scrt ) cout << "// DIF i.e. revbin_permute() AFTER core-loop" << endl;
//    else        cout << "// DIT i.e. revbin_permute() BEFORE core-loop" << endl;

//    if  ( scrt==0 )  cout<<"revbin_permute(f,"<<n<<");"<<endl;

    mct = act = 0;

}
// ===================== end =====================


void
finale(ulong n, int scrt)
{
//    if  ( scrt )  cout<<"revbin_permute(f,"<<n<<");"<<endl;

//    cout << "// jjend" << endl;
    cout<<"}" << endl;
    cout << "// ============== "<<endl;

    cout << "// opcount by generator:  #mult=" << mct << "=" << 1.0*mct/n << "/pt"
         << "   #add=" << act << "=" << 1.0*act/n << "/pt" << endl;
//    cerr << "n=" << n << " ";
//    cerr << "// opcount by generator:  #mult=" << mct << "=" << 1.0*mct/n << "/pt"
//         << "   #add=" << act << "=" << 1.0*act/n << "/pt" << endl;
}
// ===================== end =====================
