
#include <math.h>

#include "copy.h"


void
haar(double *f, ulong ldn, double *ws/*=0*/)
//
// transform wrt. to haar base
//
{
    ulong n = (1<<(ulong)ldn);
    double s2 = sqrt(0.5);
    double v = 1.0;

    double *g;
    if ( !ws )  g = new double[n];
    else        g = ws;

    for (ulong m=n; m>1; m>>=1)
    {
        v *= s2;

	ulong mh = (m>>1);
        for (ulong j=0,k=0; j<m; j+=2,k++)
        {
            double x = f[j];
            double y = f[j+1];
            g[k]    =  x+y;
            g[mh+k] = (x-y)*v;
        }

        copy(g,f,m);
    }

    f[0] *= v; // *=1.0/sqrt(n); 

    if ( !ws )  delete [] g;
}
// ============= end  ===============


void
inverse_haar(double *f, ulong ldn, double *ws/*=0*/)
//
// inverse transform wrt. to haar base
//
{
    ulong n = (1<<(ulong)ldn);
    double s2 = sqrt(2.0);
    double v = 1.0/sqrt(n);

    double *g;
    if ( !ws )  g = new double[n];
    else        g = ws;

    f[0] *= v;

    for (ulong m=2; m<=n; m<<=1)
    {
	ulong mh = (m>>1);

        for (ulong j=0,k=0; j<m; j+=2,k++)
        {
            double x = f[k];
            double y = f[mh+k] * v;
            g[j]    =  x+y;
            g[j+1]  =  x-y;
        }

        copy(g,f,m);
        v *= s2;
    }

    if ( !ws )  delete [] g;
}
// ============= end  ===============
