#if !defined __JJASSERT_H
#define      __JJASSERT_H

// if you don't have sys/cdefs.h just uncomment the next line:
#include <sys/cdefs.h>  // __STRING() 


void
jjassert_fail(
              const char *func,
              const char *pretty_func,
              const char *file,
              const int   line,
              const char *expr,
              const char *bla
              );


#if defined  NDEBUG

#define jjassert(expr)
#define jjassert2(expr, bla)

#else // NDEBUG

#ifndef  __STRING
#define  __STRING(s)   __XSTRING(s)
#define  __XSTRING(s)  #s
#endif

#define jjassert(expr) \
if ( !(expr) )  \
jjassert_fail( \
__FUNCTION__, \
__PRETTY_FUNCTION__, \
__FILE__, \
__LINE__, \
__STRING(expr), \
0)

#define jjassert2(expr, bla) \
if ( !(expr) )  \
jjassert_fail( \
__FUNCTION__, \
__PRETTY_FUNCTION__, \
__FILE__, \
__LINE__, \
__STRING(expr), \
bla)


#endif // NDEBUG


#endif  // !defined __JJASSERT_H
