
#include <math.h>

#include "fxtaux.h"
#include "permute.h"


void
dit2_fft_localized(Complex *f, ulong ldn, int is)
// decimation in time radix 2 fft
// depth-first version
// compared to usual fft this one
// - does more trig computations
// - is (far) better memory local
{
    const ulong n = 1<<ldn;
    const double pi = is*M_PI;

    revbin_permute(f,n);

    for (ulong ldm=1; ldm<=ldn; ++ldm)
    {
        const ulong m = (1<<ldm);  // m = 2^ldm
	const ulong mh = (m>>1);   // mh = m/2

        const double phi = pi/(double)(mh);

        for (ulong r=0; r<n; r+=m)
        {
            for (ulong j=0; j<mh; ++j)
            {
                ulong t1 = r+j;
                ulong t2 = t1+mh;

                Complex u = f[t1];
                double c, s;
                sincos(phi*(double)j, &s, &c);
                Complex v = f[t2] * Complex(c,s);

                f[t1] = u + v;
                f[t2] = u - v;
            }
        }
    }
}
// ================ end ====================


void
dit2_fft(Complex *f, ulong ldn, int is)
// decimation in time radix 2 fft
{
    const ulong n = 1<<ldn;
    const double pi = is*M_PI;

    revbin_permute(f,n);

    for (ulong ldm=1; ldm<=ldn; ++ldm)
    {
        const ulong m = (1<<ldm);  // m = 2^ldm
	const ulong mh = (m>>1);   // mh = m/2

        const double phi = pi/(double)(mh);

        for (ulong j=0; j<mh; ++j)
        {
	    double c,s;
            sincos(phi*(double)j, &s, &c);

            for (ulong r=0; r<n; r+=m)
            {
                ulong t1 = r+j;
                ulong t2 = t1+mh;
                Complex u = f[t1];
                Complex v = f[t2] * Complex(c,s);
                f[t1] = u + v;
                f[t2] = u - v;
            }
        }
    }
}
// ================ end ====================


void
dit2_fft(double *fr, double *fi, ulong ldn, int is)
// decimation in time radix 2 fft
{
    const ulong n = 1<<ldn;

    const double pi = is*M_PI;

    revbin_permute(fr,n);
    revbin_permute(fi,n);

    for (ulong ldm=1; ldm<=ldn; ++ldm)
    {
        const ulong m = (1<<ldm);  // m = 2^ldm
	const ulong mh = (m>>1);   // mh = m/2

        const double phi = pi/(double)(mh);

        for (ulong j=0; j<mh; ++j)
        {
	    double c,s;
            sincos(phi*(double)j, &s, &c);

            for (ulong r=0; r<n; r+=m)
            {
                ulong t1 = r+j;
                ulong t2 = t1+mh;

                double vr = fr[t2] * c - fi[t2] * s;
                double vi = fr[t2] * s + fi[t2] * c;

                double ur = fr[t1];
                fr[t1] = ur + vr;
                fr[t2] = ur - vr;

                double ui = fi[t1];
                fi[t1] = ui + vi;
                fi[t2] = ui - vi;
            }
        }
    }
}
// ================ end ====================
