
#include "fxttypes.h"
#include "fxtaux.h" // copy()
#include "fxt.h" // fourier_shift()
#include "permute.h"

#include <math.h>


static void
evenodd_permute(const Complex *a, Complex *ev, Complex *od, ulong n)
{
    for (ulong k=0,j=0; j<n; k+=2,j++)
    {
        ev[j] = a[k];
        od[j] = a[k+1];
    }
}
// ================ end ====================


static void
recursive_dit2_fft_core(const Complex *a, ulong n, Complex *x, int is)
{
    if ( n==1 )
    {
        x[0] = a[0];
        return;
    }

    ulong nh = n/2;

    Complex *b = new Complex[nh];
    Complex *c = new Complex[nh];
    Complex *ev = new Complex[nh];
    Complex *od = new Complex[nh];


    evenodd_permute(a, ev, od, nh);

    recursive_dit2_fft_core(ev, nh, b, is);
    recursive_dit2_fft_core(od, nh, c, is);

    fourier_shift(c, nh, is*0.5);

    for (ulong k=0; k<nh; k++)
    {
        x[k]    = b[k] + c[k];
        x[k+nh] = b[k] - c[k];
    }

    delete [] c;
    delete [] b;
    delete [] ev;
    delete [] od;
}
// ================ end ====================

void
recursive_dit2_fft(Complex *a, ulong ldn, int is)
//
// very inefficient, just here to demonstrate the
// recursive fast fourier transform
//
{
    ulong n = (1<<ldn);
    Complex *x = new Complex[n];

    recursive_dit2_fft_core(a, n, x, is);
    copy(x, a, n);

    delete [] x;
}
// ================ end ====================

