#if !defined __MODM_H
#define      __MODM_H


#include "mtypes.h"
#include "factor.h"


inline umod_t pow2(uint x)  { return (1ULL<<x); }
 
// arithmodm.cc:
umod_t mod_mod(umod_t x, umod_t m);
umod_t incr_mod(umod_t a, umod_t m);
umod_t decr_mod(umod_t a, umod_t m);
umod_t add_mod(umod_t a, umod_t b, umod_t m);
umod_t sub_mod(umod_t a, umod_t b, umod_t m);
umod_t mul_mod(umod_t a, umod_t b, umod_t m);
umod_t pow_mod(umod_t a, umod_t ex, umod_t m);
umod_t inv_modp(umod_t a, umod_t p);
umod_t inv_modpp(umod_t a, umod_t p, long ex);
umod_t inv_mod(umod_t a, umod_t m);
umod_t div_mod(umod_t a, umod_t b, umod_t m);

// erastothenes.cc:
uint erastothenes(uint m);
uint prime(uint n);

// kronecker.cc:
int reciprocity(umod_t a, umod_t b);
int kronecker(umod_t a, umod_t b);

// ipow.cc:
umod_t ipow(umod_t a, umod_t ex);

// phi.cc:
umod_t phi(umod_t n); 
umod_t phi(umod_t pr, int ex);
umod_t phi(const factorization &ff);

// rabinmiller.cc
void n2qt(const umod_t n, umod_t &q, int &t);
int rabin_miller_pass(const umod_t n, const umod_t a, const umod_t q, const int t);
int is_pseudoprime(umod_t n, uint cm=0);

// sqrtmodp.cc:
umod_t sqrt_modf(umod_t a, const factorization &mf);
umod_t sqrt_modpp(umod_t a, umod_t p, long ex);
umod_t sqrt_modp(umod_t a, umod_t p);
int is_quadratic_residue(umod_t a, const factorization &mf);
int is_quadratic_residue(const factorization &af, umod_t m);

// chinese.cc:
umod_t chinese(const umod_t *x, const factorization &f);

// gcd.cc:
umod_t gcd(umod_t a, umod_t b);
smod_t binary_gcd(smod_t a, smod_t b);
umod_t lcm(umod_t a, umod_t b);
umod_t u_egcd(umod_t a, umod_t b, umod_t &u, umod_t &v);
smod_t egcd(smod_t a, smod_t b, smod_t &s, smod_t &v);
smod_t egcd_core(smod_t u, smod_t v, smod_t &u1, smod_t &u2);


#endif  // !defined __MODM_H
