
#include <iostream.h>

#include "mod.h"
#include "modm.h"
#include "factor.h"


umod_t
phi(umod_t n)
{
    factorization ff(n);
    return  phi(ff);
}
//================= end ================

umod_t
phi(umod_t pr, int ex)
{
    umod_t v = pr-1;
    if ( ex>1 )  v *= ipow(pr,ex-1);
    return v;
}
//================= end ================

umod_t
phi(const factorization &ff)
//
// let f = \prod_i{p_i^{e_i}}
// then phi(f) =
//  == \prod_i{ phi(p_i^{e_i}) }
//  == \prod_i{ p_i^{e_i}-p_i^{e_i-1} }
//  == \prod_i{ (p_i-1) * p_i^{e_i-1} }
//
{
//    cout << "\n phi(): " << endl;

    umod_t p = 1;
    for (int i=0; i<ff.npr; ++i)
    {
        p *= phi(ff.prime[i],ff.expon[i]);
    }

    return p;
}
//================= end ================
