
#include <assert.h>
#include <iostream.h>

#include "mtypes.h"


// mod( 8758970186221256706 * 8758970186221256706, 9223050979459465217)
// == 7435258831429971283
// != 7435900946220592465

static umod_t m = 0;
static ldouble MODULUS = 0.0;
static ldouble M1DD = 0.0;
static const ldouble ld12 = (ldouble)1/2;
//static const ldouble ld12 = (ldouble)1/10;

char abm[] = "8318240774552146609.806160439";


inline umod_t
mmm1(const umod_t &a, const umod_t &b)
{
    umod_t x = a * b;
    cout << " mmm1():  ld(a*b)=" << (ldouble)a*(ldouble)b << endl;
    cout << " mmm1():  ld(a*b/?)=" << (ldouble)a*(ldouble)b/MODULUS << endl;
    cout << " mmm1():  =?=   abm=" << abm << endl;
    ldouble q = (ldouble)a*(ldouble)b/MODULUS+ld12;
    cout << " mmm1():  q=" << q << endl;
    cout << " mmm1():  (umod_t)q=" << (umod_t)q << endl;
    umod_t y = m * (umod_t)( q );
    cout << " mmm1():  y=" << y << endl;
    smod_t r = (smod_t)(x-y);
    cout << " mmm1():  r=" << r << endl;
    if ( r<0 )  r += m;
    return  (umod_t)r;
}

inline umod_t
mmm2(const umod_t &a, const umod_t &b)
{
    umod_t x = a * b;
    cout << " mmm2():  ld(a*b)=" << (ldouble)a*(ldouble)b << endl;
    cout << " mmm2():  ld(a*(b*?))=" << (ldouble)a*((ldouble)b*(M1DD)) << endl;
    cout << " mmm2():  ld(a*b*?)=" << (ldouble)a*(ldouble)b*(M1DD) << endl;
    cout << " mmm2():  =?=   abm=" << abm << endl;
    ldouble q = (ldouble)a*(ldouble)b*(M1DD)+ld12;
    cout << " mmm2():  q=" << q << endl;
    cout << " mmm2():  (umod_t)q=" << (umod_t)q << endl;
    umod_t y = m * (umod_t)( q );
    cout << " mmm2():  y=" << y << endl;
    smod_t r = (smod_t)(x-y);
    cout << " mmm2():  r=" << r << endl;
    if ( r<0 )  r += m;
    return  (umod_t)r;
}


int
main()
{
    m = 9223050979459465217ULL;
    MODULUS = (ldouble)m;
    M1DD = (ldouble)1/(ldouble)m;


    cout.precision(35);
    cout << " m= " << m << endl;
    cout << " MODULUS= " << MODULUS << endl;
    cout << " M1DD= " << M1DD << endl;
    cout << " M1DD*MODULUS - 1= " << endl;
    cout << " ld12=" << ld12 << endl;    
//    cout << M1DD*MODULUS - 1 << endl;

    umod_t a = 8758970186221256706ULL;
    umod_t b = 8758970186221256706ULL;
    umod_t c = 7435258831429971283ULL;

    cout << endl;
    cout << "a=" << a << endl;
    cout << "b=" << b << endl;
    cout << "c=" << c << endl;

    umod_t r1,r2;
    r1 = mmm1(a,b);
    r2 = mmm2(a,b);

    cout << "r1=" << r1 << endl;
    cout << "r2=" << r2 << endl;

    return 0;
}
