
#include "fxttypes.h"
#include "fxtmult.h"
#include "diskaux.h"
#include "auxtempl.h"  // copy()


void
disk_carry_thru_2limb(double *f, ulong fn, ulong al, 
                      int fd,
                      uint rx, ulong &cyi,
                      LIMB *c, ulong cn, ulong coff,
                      ulong &si)
//
// expect al*fn doubles on disk
// carry thru (from right to left) using f[0..fn-1] as workspace
// compute sum of digits and put to si
//
{
    double cy = cyi;
    ulong off = (al-1)*fn;  // last block
    ulong s = si;

    coff += off;            // offset in c[]
    while ( al )
    {
        seek_read(fd, off, f, fn);
        carry_thru(f, fn, rx, cy);

        s = sum_of_digits(f, fn, rx-1, s);

        if ( cn>=coff )
        {
            ulong n = cn - coff;
            if ( n>fn )  n = fn;
            copy(f, c+coff, n);
        }

        off -= fn;
        coff -= fn;
        al--;
    }

    cyi = (ulong)cy;
    si = s;
}
// ================== end ===================

void
zeroes2disk(double *f, ulong fn, ulong al,
            int fd, ulong off/*=0*/)
//
// write  al*fn (double-) zeroes to the file with filedescriptor fd,
// start at offset off
//
{
    null(f,fn);
    while ( al )
    {
        seek_write(fd, off, f, fn);
        off += fn;
        al--;
    }
}
// ================== end ===================

void
limb2disk(const LIMB *a, ulong an,
          double *f, ulong fn, ulong al,
          int fd)
//
// write a[0..an-1] as doubles to the file with filedescriptor fd
// if al*fn > an  then append al*fn-an zeroes
//
{
    ulong off = 0;

    // blocks filled with digits form a[]:
    while ( al && (an>=fn) )
    {
        copy(a, f, fn);
        seek_write(fd, off, f, fn);
        off += fn;
        an -= fn;
        a += fn;
        al--;
    }

    if ( al==0 )  return;

    // block partially filled from a[]:
    copy(a, an, f, fn);    // an<fn
    seek_write(fd, off, f, fn);
    off += fn;
    al--;

    // zeroes:
    if ( al!=0 )  zeroes2disk(f, fn, al, fd, off);
}
// ================== end ===================
