
#include "fxt.h"
#include "diskaux.h"
#include "jjassert.h"


void
disk_col_pass1(int fd1, int fd2,
               double *fr, double *fi,
               ulong nr, ulong nc, ulong xc,
               double w,
               int zq/*=0*/)
//
// zq = 1  =-->  imag part is zero (at start)
//
{
    const int is = +1;  // MUST be same as in disk_row_pass()

    ulong n = nr*nc;
    ulong nb = nc/xc;  // how many blocks
    for (ulong b=0;  b<nb;  ++b)
    {
        double *pr, *pi;
        pr = fr;
        pi = fi;
        for (ulong j=0, kk=b*xc;  j<nr;  ++j, kk+=nc) // kk = j*nc+b*xc;
        {
            seek_read(fd1, kk, pr, xc);
            if ( zq!=1 )  seek_read(fd2, kk, pi, xc);

            if ( w!=0 )
            {
                if ( zq==1 )  fourier_shift0(pr, pi, n, w, kk, xc);
                else          fourier_shift(pr, pi, n, w, kk, xc);
            }

            pr += xc;
            pi += xc;
        }

        column_ffts(fr, fi, nr, xc, is, 0, 0, 0);
        
        pr = fr;
        pi = fi;
        for (ulong j=0, kk=b*xc;  j<nr;  ++j, kk+=nc) // kk = j*nc+b*xc;
        {
            seek_write(fd1, kk, pr, xc);
            seek_write(fd2, kk, pi, xc);

            pr += xc;
            pi += xc;
        }
    }
}
// ================== end ===================


void
disk_col_pass3(int fd1, int fd2,
               double *fr, double *fi,
               ulong nr, ulong nc, ulong xc,
               double w,
               int zq/*=0*/)
//
// zq = 1  =-->  real part of output is discarded
// zq = 2  =-->  imag part of output is discarded
{
    const int is = +1;  // MUST be same as in disk_row_pass()

    ulong n = nr*nc;
    ulong nb = nc/xc;  // how many blocks
    for (ulong b=0;  b<nb;  ++b)
    {
        double *pr, *pi;
        pr = fr;
        pi = fi;
        for (ulong j=0, kk=b*xc;  j<nr;  ++j, kk+=nc) // kk = j*nc+b*xc;
        {
            seek_read(fd1, kk, pr, xc);
            seek_read(fd2, kk, pi, xc);

            pr += xc;
            pi += xc;
        }

        column_ffts(fr, fi, nr, xc, -is, 0, 0, 0);
        
        pr = fr;
        pi = fi;
        for (ulong j=0, kk=b*xc;  j<nr;  ++j, kk+=nc) // kk = j*nc+b*xc;
        {
            if ( w!=0 )   fourier_shift(pr, pi, n, -w, kk, xc);

            if ( zq!=1 )  seek_write(fd1, kk, pr, xc);
            if ( zq!=2 )  seek_write(fd2, kk, pi, xc);

            pr += xc;
            pi += xc;
        }
    }
}
// ================== end ===================

