#if !defined __EVENODDREVPERMUTE_H
#define      __EVENODDREVPERMUTE_H


#include "fxttypes.h"
#include "reverse.h"
#include "revbinpermute.h"


template <typename Type>
void
inverse_evenoddrev_permute(const Type *x, Type *y, ulong n)
// reordering needed for fht based dct
{
    const ulong nh = n/2;
    for (ulong k=0, k2=0;  k<nh;  k++, k2+=2)
    {
        y[k] = x[k2];
        y[nh+k] = x[n-1-k2];
    }
}
// =============== end =========== 

template <typename Type>
void
inverse_evenoddrev_permute(Type *x, ulong n)
// reordering needed for fht based dct
// inplace version
{
    const ulong nh = n/2;
    revbin_permute(x, n);
    revbin_permute(x, nh); revbin_permute(x+nh, nh);
    reverse(x+nh, nh);
}
// =============== end =========== 


template <typename Type>
void
evenoddrev_permute(const Type *y, Type *x, ulong n)
// reordering needed for fht based inverse dct
{
    const ulong nh = n/2;
    for (ulong k=0, k2=0;  k<nh;  k++, k2+=2)
    {
        x[k2] = y[k];
        x[n-1-k2] = y[nh+k];
    }
}
// =============== end =========== 


template <typename Type>
void
evenoddrev_permute(Type *x, ulong n)
// reordering needed for fht based inverse dct
// inplace version
{
    const ulong nh = n/2;
    reverse(x+nh, nh);
    revbin_permute(x, nh); revbin_permute(x+nh, nh);
    revbin_permute(x, n);
}
// =============== end ===========


#endif // !defined __EVENODDREVPERMUTE_H
