#if !defined __SHORTREVBINPERMUTE_H
#define      __SHORTREVBINPERMUTE_H


template <typename Type>
inline void
revbin_permute_2(Type *f)
// unrolled version for length 2
{
}  // # of swaps = 0

template <typename Type>
inline void
revbin_permute_4(Type *f)
// unrolled version for length 4
{
swap(f[1], f[2]);
}  // # of swaps = 1

template <typename Type>
inline void
revbin_permute_8(Type *f)
// unrolled version for length 8
{
swap(f[1], f[4]);
swap(f[3], f[6]);
}  // # of swaps = 2

template <typename Type>
inline void
revbin_permute_16(Type *f)
// unrolled version for length 16
{
swap(f[1], f[8]);
swap(f[2], f[4]);
swap(f[3], f[12]);
swap(f[5], f[10]);
swap(f[7], f[14]);
swap(f[11], f[13]);
}  // # of swaps = 6

template <typename Type>
inline void
revbin_permute_32(Type *f)
// unrolled version for length 32
{
swap(f[1], f[16]);
swap(f[2], f[8]);
swap(f[3], f[24]);
swap(f[5], f[20]);
swap(f[6], f[12]);
swap(f[7], f[28]);
swap(f[9], f[18]);
swap(f[11], f[26]);
swap(f[13], f[22]);
swap(f[15], f[30]);
swap(f[19], f[25]);
swap(f[23], f[29]);
}  // # of swaps = 12

template <typename Type>
inline void
revbin_permute_64(Type *f)
// unrolled version for length 64
{
swap(f[1], f[32]);
swap(f[2], f[16]);
swap(f[3], f[48]);
swap(f[4], f[8]);
swap(f[5], f[40]);
swap(f[6], f[24]);
swap(f[7], f[56]);
swap(f[9], f[36]);
swap(f[10], f[20]);
swap(f[11], f[52]);
swap(f[13], f[44]);
swap(f[14], f[28]);
swap(f[15], f[60]);
swap(f[17], f[34]);
swap(f[19], f[50]);
swap(f[21], f[42]);
swap(f[22], f[26]);
swap(f[23], f[58]);
swap(f[25], f[38]);
swap(f[27], f[54]);
swap(f[29], f[46]);
swap(f[31], f[62]);
swap(f[35], f[49]);
swap(f[37], f[41]);
swap(f[39], f[57]);
swap(f[43], f[53]);
swap(f[47], f[61]);
swap(f[55], f[59]);
}  // # of swaps = 28


#endif // !defined __REVBINPERMUTE_H
