
#include "fxt.h"
#include "fxtaux.h"

#include <assert.h>


void
fxt(Complex *f, ulong ldn, int is)
{
    const ulong n = (1<<ldn);

    revbin_permute(f,n);  // dit
//    for (ulong ldm=ldn; ldm>=1; --ldm) // dif
    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    {
        const ulong m = (1<<ldm);
	const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r + mh;
//            reverse(f+r+mh,mh);
            fourier_shift(f+r+mh, mh, is*0.5);  // dit
//            reverse(f+r+mh,mh);

            for (ulong j=0; j<mh; ++j,++t1,++t2)
//            for (  ; t1<t2; ++t1,--t2)
            {
                Complex u = f[t1];
		Complex v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
//            fourier_shift(f+r+mh, mh, is*0.5);  // dif
//            reverse(f+r+mh,mh);
        }
    }

//    revbin_permute(f,n);  // dif
}
// ================= end ==================


void
fxt(double *fr, double *fi, ulong ldn, int is)
{
    const ulong n = (1<<ldn);
    assert( fr+n == fi );
    evenodd_permute(fr,2*n);
    fxt((Complex *)fr, ldn, is);
    inverse_evenodd_permute(fr,2*n);
}
// ================= end ==================
