#include <math.h>
#include <assert.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <time.h>  // time()
#include <stdlib.h> // atol()

#include "fxt.h"
#include "../permute/permute.h"
#include "fxtaux.h"
#include "fxtdefs.h"
//#include "../mult/diskaux.h"

#include "testaux.cc"  // yuck
//#include "permute.cc"  // yuck
#include "fxttest.cc"  // yuck

void
test_walsh_circ(Complex *f, ulong ldn)
{
    const ulong n = (1<<ldn);
    const double pi = M_PI;

    revbin_permute(f,n);
//    inverse_evenoddrev_permute(f, n);
    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        const double phi = pi/(double)(mh);

        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;
            Complex *f1 = f+t1;
            Complex *f2 = f+t2;
            reverse(f2, mh);
            t2 = r + m - 1;
            for (ulong j=0; j<mh; ++j,++t1,--t2)
            {
                Complex u = f[t1];

                double c, s;
                sincos(phi*(double)j, &s, &c);
                Complex v = f[t2] * Complex(c,s);

                f[t1] = u + v;
                f[t2] = u - v;
            }
//            reverse(f2, mh);
        }
    }
//    evenoddrev_permute(f, n);
//    revbin_permute(f, n);
//    reverse(f+n/2, n/2);
}
// ================= end ==================

void
prseq(double *f, ulong n)
{
    for (ulong k=0; k<n; ++k)
    {
        if ( k && 0==k%8 )  cout << ", ";
        cout.width(3);
        cout << f[k];
    }
    cout << endl;
}
// ================= end ==================

int
main(int argc, char **argv)
{
//    cout << __FILE__ << endl;
    ulong ldn = 3;
    if ( argc>1 )  ldn = atol(argv[1]);
    ulong  n = (1<<ldn), nh = n/2, n4 = n/4;

    ulong delta = 1;
    if ( argc>2 )  delta = atol(argv[2]);
    if ( delta>=n )  delta = n-1;
    cout << "ldn=" << ldn << "  n=" << n << endl;

//    n *= 2;
    Complex *ac = new Complex[n];   null( ac, n );
    Complex *fc = new Complex[n];   null( fc, n );
    Complex *gc = new Complex[n];   null( gc, n );
//    n /= 2;

    double *ar, *ai, *fr, *fi, *gr, *gi;
    ar = (double *)ac;
    ai = ar + n;
    fr = (double *)fc;
    fi = fr + n;
    gr = (double *)gc;
    gi = gr + n;

    int is = +1;  // ISIGN
    double phi = is*2*M_PI/n;
    double z = 2.0;

//    for (ulong ldx=1; ldx<=ldn; ++ldx)
    for (delta=0; delta<n; ++delta)
    {
        cout << "\n ------------- delta_" << delta << endl;

        null(ac, n);
        ac[delta] = 1;
//        for (ulong i=0; i<n; ++i)  ar[i] = white_noise();
//        for (ulong i=0; i<n; ++i)  ar[i] = pow(z, 1.0*delta*i/n);
//        for (ulong i=0; i<n; ++i)  ai[i] = 1e99;
        for (ulong i=0; i<n; ++i)
        {
//            sincos(-phi*delta*i, ai+i, ar+i);
            double c, s;
            sincos(-phi*delta*i, &s, &c);
            ac[i] = Complex(c,s);
        }
        copy(ac, fc, n);

        fft(ac, ldn, is);
        test_walsh_circ(fc, ldn);

//        is_delta(fr,n,delta,1.0*n);

//        dcth(ar, ldn);
//        for (ulong i=0; i<n; ++i)  ar[i] = cos(M_PI*i*(delta+0.5)/n)*(i==0?1.0:sqrt(2));
//        dcth(fr, ldn);
//        dct_zapata(fr, ldn);
//        slow_zt(fr, n, z);

//        prseq(fr, n);  cout << endl;


        if ( rms_diff(ar, fr, 2*n) > 1e-10 )
        {
            approx_eq(ar, fr, 2*n," ?equal? ",1e-10);
//            approx_eq(ac, fc, n," ?equal? ",1e-10);
//            assert(0);
        }
        else  cout << "OK." << endl;
    }
    exit(0); //////////////////

    approx_eq((double *)ac, (double *)fc, 2*n," ?equal? ",1e-6);
    exit(0); //////////////////

//    approx_eq((double *)a2c, (double *)f2c, 2*n," ?equal? ",1e-6);
    approx_eq((double *)ac, (double *)fc, 2*n," ?equal? ",1e-6);
//    approx_eq(ar,fr,2*n," ?equal? ",1e-6);

    return 0;
}
//===========================================


// xv tmp.pgm -geometry 512x512 -raw &
// killall -QUIT xv

