

#include "fxtaux.h"  // swap()


//  revbin_permute() put data into revbin order
//  revbin_permute0() same for zero padded data


#define VERSION  2  // 0, 1 or 2  (2 faster 1 faster 0)

/*
 approx. timing: (in msec/call for length 2^20, cpu= AMD K6/233)
   revbin_permute() revbin_permute0()
2:    352       249
1:    362       250
0:    733       465
runtime of null()  (set array to zero):
          117
runtime of swap_nh() (swapping all elements k=1...n/2 with elements n-k):
          118

for length 2^23:
2:  2979    2103
1:  3120    2128
null:      962
swap_nh():   939
*/



#if VERSION==2
//#warning "FYI: using revbin_permute version 2"

void
revbin_permute(double *f, ulong n)
{
    if ( n<=2 )  return;

    const ulong nh = (n>>1);
    double * const f1 = f+n-1;
    for (ulong k=1,r=0; k<nh; )
    {
        // k odd:
        r += nh;
        swap(f[k],f[r]);
        k++;

        // k even:
        r^=nh;  for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)  {}
   	if ( r>k )
        {
            swap(f[k],f[r]);
            swap(f1[-k],f1[-r]);
        }
        k++;
    }
}
//============== end =================


void
revbin_permute0(double *f, ulong n)
{
    if ( n<=2 )  return;

    const ulong nh = (n>>1);
    for (ulong k=1,r=0; k<nh; )
    {
        // k odd:
        r += nh;
        f[r] = f[k];
        f[k] = 0;
        k++;

        // k even:
        r^=nh;  for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)  {}
   	if ( r>k )  swap(f[k],f[r]);
        k++;
    }
}
//============== end =================

#endif  // VERSION==2


#if VERSION==1
//#warning "FYI: using revbin_permute version 1"

void
revbin_permute(double *f, ulong n)
{
    if ( n<=2 )  return;

    for (ulong k=1,r=0; k<n-1; k++)
    {
	for (ulong m=n>>1; !((r^=m)&m); m>>=1)  {}

	if ( r>k )  swap(f[k],f[r]);
    }
}
//============== end =================


void
revbin_permute0(double *f, ulong n)
{
    if ( n<=2 )  return;

    for (ulong k=1,r=0; k<n/2; k++)
    {
	for (ulong m=n>>1; !((r^=m)&m); m>>=1)  {}

	if ( r>k )
        {
	    f[r] = f[k];
	    f[k] = 0;
	}

	k++;

	for (ulong m=n>>1; !((r^=m)&m); m>>=1)  {}

	if ( r>k )  swap(f[k],f[r]);
    }
}
//============== end =================


#endif  // VERSION==1


#if VERSION==0
//#warning "FYI: using revbin_permute version 0"

inline ulong
inl_revbin(ulong m, ulong ldn)
{
    ulong j=0;

    while (ldn-->0)
    {
        j<<=1;
        j += (m&1);
        m>>=1;
    }

    return j;
}
//============== end =============

void
revbin_permute(double *f, ulong n)
{
    if ( n<=2 )  return;

    ulong ldn=ld(n);

    for (ulong m=1; m<n-1; ++m)
    {
        ulong j=inl_revbin(m,ldn);

        if (j>m) swap(f[m],f[j]);
    }
}
//============= end ===========


void
revbin_permute0(double *f, ulong n)
{
    if ( n<=2 )  return;

    ulong ldn=ld(n);

    for (ulong m=1; m<n/2; ++m)
    {
        ulong j=inl_revbin(m,ldn);

        if (j>m)
	{
            f[j]=f[m];
            f[m]=0.0;
        }

        ++m;
        j = inl_revbin(m,ldn);

        if (j>m) swap(f[m],f[j]);
    }
}
//============= end ===========


#endif  // VERSION==0


ulong
revbin(ulong m, ulong ldn)
//
// m=number, ldn=length of m in bits minus one
// used by revbin_permute()
//
{
    ulong j=0;

    while ( ldn-->0 )
    {
        j <<= 1;
        j += (m&1);
        m >>= 1;
    }

    return j;
}
//============== end =============



#include <iostream.h>
#include <iomanip.h>


void
bin_print(ulong n, ulong ldn)
{
    n = revbin(n,ldn);
    while ( ldn-- )
    {
        cout << (n&1?'1':'0');
        n >>= 1;
    }
    
}
//============== end =============

int main()
{
//    for (ulong ldk=1; ldk<=5; ldk++)
//    {
//        ulong k = (1<<ldk);
//        cout << " --- k=" << k << " ---" << endl;
//        cout << setfill(' ');
//        for (int i=0; i<k; ++i)
//        { cout.width(3); cout << i << ' '; }
//        cout << endl;
//        for (int i=0; i<k; ++i)
//        { cout.width(3); cout << revbin(i,ldk) << ' '; }
//        cout << endl;
//        cout << endl;
//    }

    ulong ldn = 5;
    ulong n = (1<<ldn);
    for (ulong k=0; k<n; ++k)
    {
        ulong r = revbin(k,ldn);
        cout.width(2); cout << k;
        cout << " & ";
        bin_print(k,ldn);
        cout << " & ";
        bin_print(r,ldn);       
        cout << " & ";
        cout.width(2); cout << r;
        cout << " & ";
        cout.width(3); cout << (long)(revbin(k,ldn)-revbin(k-1,ldn));
        cout << " & ";
        cout << (r>k?'y':' ');
        cout << " \\\\" << endl;
    }
}


/*
--- k=2 ---
  0   1
  0   1

 --- k=4 ---
  0   1   2   3
  0   2   1   3

 --- k=8 ---
  0   1   2   3   4   5   6   7
  0   4   2   6   1   5   3   7

 --- k=16 ---
  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
  0   8   4  12   2  10   6  14   1   9   5  13   3  11   7  15

 --- k=32 ---
  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
  0  16   8  24   4  20  12  28   2  18  10  26   6  22  14  30

  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31
   1  17   9  25   5  21  13  29   3  19  11  27   7  23  15  31
   */
