
#include "fxt.h"
#include "reverse.h"
#include "fxtdefs.h"  // SUMDIFF, CSQR, CMULT


void
easy_ordering_real_complex_fft(double *f, ulong ldn)
//
// isign = +1
//
// ordering on output is same as in wrap_real_complex_fft():
// f[0]     = re[0]
// f[1]     = re[1]
//         ...
// f[n/2-1] = re[n/2-1]
// f[n/2]   = re[n/2](==nyquist freq)
//
// f[n/2+1] = im[1]  (wrt. compl fft with isign=+1)
// f[n/2+2] = im[2]
//         ...
// f[n-1]   = im[n/2-1]
//
// corresponding real and imag parts (with the exception of
// zero and nyquist freq) are found in f[i] and f[n/2+i]
//
{
    fht_real_complex_fft(f,ldn);

    if ( ldn>=2 )
    {
        ulong nh = (1<<ldn)/2;
        reverse(f+nh+1,nh-1);    
    }
}
// =============== end =========== 
   

void
easy_ordering_real_complex_fft0(double *f, ulong ldn)
//
// version for zero padded data
//
// ordering on output:
// see easy_ordering_real_complex_fft()
//
{
    fht_real_complex_fft0(f,ldn);

    if ( ldn>=2 )
    {
        ulong nh = (1<<ldn)/2;
        reverse(f+nh+1, nh-1);    
    }
}
// =============== end =========== 
   
void
easy_ordering_complex_real_fft(double *f, ulong ldn)
//
// isign = +1
//
// expected ordering on input:
// like the output of easy_ordering_real_complex_fft()
//
{
    if ( ldn<1 )  return;

    const ulong n = (1<<ldn);
    const ulong nh = (n>>1);

    for (ulong i=1,j=nh+1; i<nh; i++,j++)
    {
        SUMDIFF2(f[i],f[j]);
    }

    fht(f,ldn);    
}
// =============== end ===========
