#!/bin/sh

# lists *.cc files depending on some.h
# usage:  $0 some.h
# e.g.
#  $0 '\bfxt.h\b'
#  $0 'auxdouble.h'


INVDEP=/tmp/invdep

function  mkinvdep
{
    echo "$0: building $INVDEP" 1>&2
    cp depend.mk $INVDEP
    replace -f -q '\.o:' '.cc:' $INVDEP > /dev/null
    #replace -f -q '\\\\' '%' $INVDEP
    replace -f -q '\\\\\\n' '' $INVDEP > /dev/null
}

########################

if [ -f $INVDEP ];  then
    if [ depend.mk -nt $INVDEP ];  then
        mkinvdep;
    fi
else
    mkinvdep;
fi


if [ $# -ge 1 ];  then
    egrep $1 $INVDEP  |  cut -d ':' -f1
fi


exit 0;

########################
########################
