
#include "fxttypes.h"


void
slow_convolution(const double *f, const double *g, double *r, ulong nu)
// _cyclic_ convolution
// result in g
{
    long n = (long)nu;
    for (long tau=0; tau<n; ++tau)
    {
        double s = 0.0;
//        for (long k=0; k<n; ++k)
//        {
//            long k2 = tau-k;
//            if ( k2<0 )  k2 += n;
//            s += (f[k]*g[k2]);
//        }
        long k = 0, k2 = tau;
        for (  ; k<tau; ++k,--k2)  s += (f[k]*g[k2]);
        k2 = n - 1;
        for (  ; k<n;   ++k,--k2)  s += (f[k]*g[k2]);

        r[tau] = s;
    }
}
// ============== end ================


void
slow_convolution0(const double *f, const double *g, double *r, ulong nu)
// linear convolution
// (zero padded data expected)
{
    long n = (long)nu;
    long nh = n/2;

    for (long tau=0; tau<nh; ++tau)
    {
        double s = 0.0;
        for (long k=0, k2=tau; k2>=0; ++k,--k2)  s += (f[k]*g[k2]);
        r[tau] = s;
    }

    for (long tau=nh; tau<n; ++tau)
    {
        double s = 0.0;
        for (long k=tau-nh, k2=nh; k<nh ; ++k,--k2)  s += (f[k]*g[k2]);
        r[tau] = s;
    }
}
// ============== end ================


void
slow_auto_convolution(const double *f, double *r, ulong nu)
// _cyclic_ self-convolution
{
    slow_convolution(f,f,r,nu);
}
// ============== end ================

void
slow_auto_convolution0(const double *f, double *r, ulong nu)
// linear self-convolution
// (zero padded data expected)
{
    slow_convolution0(f,f,r,nu);
}
// ============== end ================
