
#include <math.h>

#include "copy.h"
#include "fxtdefs.h"
#include "complextype.h"
#include "sincos.h"


void
slow_ft(double *fr, double *fi, ulong n, int is)
//
// (slow) fourier transform
//
{
    double *resr = new double[2*n];
    double *resi = resr + n;

    const double ph0 = is*2.0*M_PI/n;
    for (ulong w=0; w<n; ++w)
    {
        double sr=0.0, si=0.0;
        for (ulong k=0; k<n; ++k)
	{
            double c,s;
            sincos(ph0*k*w, &s, &c);
//            sincos(ph0*k*(w+sh), &s, &c);  // shifted ft

            double r,i;
            CMULT6(c, s, fr[k], fi[k], r, i);

            sr += r;
            si += i;
	}
        resr[w] = sr;
        resi[w] = si;
    }

    copy(resr, fr, n);
    copy(resi, fi, n);

    delete [] resr;
}
// ================== end ====================


void
slow_rotated_ft(double *fr, double *fi, ulong n, int is, int r)
//
// (slow) rotated fourier transform
//
{
    slow_ft(fr, fi, n, is*r);
}
// ================== end ====================


void
slow_ft(Complex *f, long n, int is)
//
// (slow) fourier transform
//
{
    Complex *res = new Complex[n];

    const double ph0 = is*2.0*M_PI/n;
    for (long w=0; w<n; ++w)
    {
        Complex t = 0.0;
        for (long k=0; k<n; ++k)
	{
            double c,s;
            sincos(ph0*k*w, &s, &c);
            t +=  f[k] * Complex(c,s);
	}
        res[w] = t;
    }

    copy(res, f, n);

    delete [] res;
}
// ================== end ====================

