

#include "copy.h"
#include "sincos.h"


void
slow_twodim_ht(double *f, ulong r, ulong c)
//
// slow 2dim hartley transform
//
{
    ulong n = r*c;
    double *res=new double[n];

    const double ph0r = 2.0*M_PI/r;
    const double ph0c = 2.0*M_PI/c;


    for (ulong wr=0; wr<r; ++wr)
    {
        for (ulong wc=0; wc<c; ++wc)
        {
            double t=0.0; 
            for (ulong kr=0; kr<r; ++kr)
            {
                for (ulong kc=0; kc<c; ++kc)
                {
                    double cs,sn;
                    sincos(ph0r*kr*wr+ph0c*kc*wc, &sn, &cs);
                    t += ((cs+sn)*f[kr*c+kc]);
                }
            }
            res[wr*c+wc] = t;
        }
    }

    copy(res,f,n);

    delete [] res;
}
// ================== end ====================
