
#include <math.h>

#include "copy.h" // null(), copy()
#include "waveletfilter.h"

void inverse_wavelet_step(double *f, long n, const wavelet_filter &wf, double *t);

void
inverse_wavelet(double *f, ulong ldn, const wavelet_filter &wf)
//
// inverse wavelet transform
//
{
    ulong n = (1<<(ulong)ldn);
    double t[n];

    for (ulong m=MINM; m<=n; m<<=1)
    {
        inverse_wavelet_step(f, m, wf, t);
    }
}
// ============= end  ===============


void
inverse_wavelet_step(double *f, long n, const wavelet_filter &wf, double *t)
//
//    wf.nwc: # of wavelet coeff.
//    wf.wvc: wavelet coeff.
//
{
    if ( n<wf.nwc )  return;

    long nh = (n>>1);
    long m = n-1;  // mask to compute modulo n

    null(t,n);

    for (long i=0,j=0; i<n; i+=2,++j)
    {
        double x = f[j];
        for (long k=0,ii=i+OFFSET1; k<wf.nwc; ++k)
        {
            long w = ((ii+k)&m); 
            t[w] +=  (wf.wvc[k]*x);
        }

        double y = f[nh+j];
        for (long k=0,ii=i+OFFSET2; k<wf.nwc; ++k)
        {
            long w = ((ii+k)&m); 
            t[w] += (wf.awvc[k]*y);
        }
    }

    copy(t,f,n);
}
// ============= end  ===============

