
#include <math.h>

#include "copy.h" // null(), copy()
#include "waveletfilter.h"


void wavelet_step(double *f, long n, const wavelet_filter &wf, double *t);

void
wavelet(double *f, ulong ldn, const wavelet_filter &wf)
//
// wavelet transform
//
{
    ulong n = (1<<(ulong)ldn);
    double t[n];

    for (ulong m=n; m>=MINM; m>>=1)
    {
        wavelet_step(f, m, wf, t);
    }
}
// ============= end  ===============


void
wavelet_step(double *f, long n, const wavelet_filter &wf, double *t)
//
//    wf.nwc: # of wavelet coeff.
//    wf.wvc: wavelet coeff.
//
{
    if ( n<wf.nwc )  return;

    long nh = (n>>1);
    long m = n-1;  // mask to compute modulo n

    null(t,n);

    for (long i=0,j=0; i<n; i+=2,++j) // i \in [0,2,4,..,n-2];  j \in [0,1,2,..,n/2-1]
    {
        double s=0.0;
        for (long k=0, ii=i+OFFSET1; k<wf.nwc; ++k)
        {
            long w = ((ii+k)&m); 

            s +=  (wf.wvc[k]*f[w]);
        }
        t[j]    = s;


        double d=0.0;
        for (long k=0, ii=i+OFFSET2; k<wf.nwc; ++k)
        {
            long w = ((ii+k)&m); 

            d += (wf.awvc[k]*f[w]);
        }
        t[nh+j] = d;
    }

    copy(t,f,n);
}
// ============= end  ===============
