#if !defined __WAVELET_H
#define      __WAVELET_H

#include <assert.h>

#include "fxttypes.h"   // for ulong

class wavelet_filter
{
public:
    long nwc;
    double *wvc, *awvc;

    wavelet_filter(const double *w);
    ~wavelet_filter();

    int check() const;
private:
    const wavelet_filter & operator =(const wavelet_filter &);
    wavelet_filter(const wavelet_filter &);
};

extern const wavelet_filter wf_test;
extern const wavelet_filter wf_haar2;
extern const wavelet_filter wf_daub4;
extern const wavelet_filter wf_daub6;
extern const wavelet_filter wf_daub8;
extern const wavelet_filter wf_daub10;
extern const wavelet_filter wf_daub12;
extern const wavelet_filter wf_daub20;

#define  MINM     (4) // must be 4

// inverse_wavelet() is inverse of wavelet() 
// iff OFFSET1==OFFSET2
#define  OFFSET1  (0) // default 0
#define  OFFSET2  (0) // default 0


#endif // !defined __WAVELET_H
