
#include <math.h>
//#include <iostream.h>

#include "hfloat.h"


int
hfloat_to_contfrac(const hfloat &x, ulong n, long cf[])
//
//  convert continued fraction to hfloat
//  this is a very careless implementation ...
//
{
    hfloat t(x.prec());
    t = x;

    ulong k = 0;
    long  xi = 0;

    while ( k<n )
    {
        hfloat2i(t,xi);  // xi = floor(t)

        cf[k] = xi;

//        print(" t=",t,16);
//        cout << " hfloat_to_contfrac(): term ";
//        cout << k << ": " << xi << endl;

        t -= xi;

        if ( t.is_zero() )
        {
            for ( ++k; k<n ; ++k)  cf[k]=0;
            break;
        }

        inv(t,t);

        ++k;
    }

    return 0;
}
//====================== end HFLOAT_TO_CONTFRAC ==========================


#define  VOODOO 1  // ... to mark somethings here

int
contfrac_to_ratio(const long cf[], ulong n, hfloat &p, hfloat &q)
//
//  convert continued fraction to ratio
//  this is a very careless implementation ...
//
{
    if ( n==0 )
    {
        p = cf[0];
        q = 1;
        return 0;
    }

    ulong prec = p.prec();
    hfloat pmm(prec), qmm(prec);
    hfloat pm(prec), qm(prec);

    pmm = 1;
    qmm = 0;

    pm = cf[0];
    qm = 1;

#if defined VOODOO
    hfloat *x = NULL;
    hfloat s5(prec);
    sqrt(5,s5);

    if ( p!=0 )
    {
        x = new hfloat(prec);
        *x = p;
    }
#endif

    for (ulong k=1; k<=n; ++k)
    {
        p = cf[k]*pm + pmm;
        q = cf[k]*qm + qmm;

#if defined VOODOO
        cout << k << ": " << endl;
        print(" p[k]= ", p, 16);
        print(" q[k]= ", q, 16);
        //        cout << " q[k]= " << q << endl;
        //        cout << " p/q=  " << (pmm=p/q) << endl;

        pmm = p;
        pmm /= q;
        //        print(" p/q=  ",pmm,32);

        if ( x )
        {
            // how good approx is (absolute value):
            pmm -= (*x);
            print(" p/q-x= ", pmm, 3);

            // how 'surprising' approx is:
            sqr(q,qmm);
            qmm *= s5;
            qmm *= pmm;  // in the order of 1, smaller values indicate good approx
            print(" (p/q-x) * (sqrt(5)*q^2)= ", qmm, 3);
        }
#endif
        pmm = pm;
        pm = p;

        qmm = qm;
        qm = q;
    }


#if defined VOODOO
    if ( x )  delete x;
#endif

    return 0;
}
//====================== end CONTFRAC_TO_RATIO ==========================


int
contfrac_to_hfloat(const long cf[], ulong n, hfloat &x)
//
//  convert continued fraction to hfloat
//  this is a very straightforward (inefficient) implementation ...
//
{
    if ( n==0 )  x = 0;
    else         x = cf[--n];

    while ( n-- )
    {
        if ( cf[n]==0 )  break;
        inv(x,x);
        x += cf[n];
    }

    return 0;
}
//====================== end CONTFRAC_TO_HFLOAT ==========================

