
#include <math.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloat.h"
#include "hfverbosity.h"
#include "inline.h"  // abs()
#include "auxbit.h"  // ld()


void
pow(const hfloat &a, long e, hfloat &c)
{
#ifdef  HF_PARANOIA
    jjassert( a.OK() );
#endif

    ulong x = abs(e);

    char *v = hfverbosity::powbegin;
    if ( x!=1 )
    {
        hfverbosity::say(v);
        if ( v )  cout << e << ':';
    }

    if ( x>=3 )
    {
        pow_geq_3(a,x,c);
    }
    else
    {
        switch ( x )
        {
        case 2: sqr(a,c); break;
        case 1: c.copy(a); break;
        case 0: u2hfloat(1,c); break;
        }
    }

    if ( e<0 )  inv(c,c);

    if ( x!=1 )  hfverbosity::say( hfverbosity::powend );

#ifdef  HF_PARANOIA
    jjassert( c.OK() );
#endif
}
//======================= end POW =============================


void
pow_geq_3(const hfloat &a, ulong x, hfloat &c)
//
// c=a^x
// exponent >= +3 
//
{
#ifdef  HF_PARANOIA
    jjassert( a.OK() );
#endif

    assert( x>=3 );

    if ( x==((ulong)1<<ld(x)) )  // special case x==2^n
    {
        sqr(a,c);

        while ( x>2 )
        {
            sqr(c,c);
            x /= 2;
        }
    }
    else
    {
	hfloat at(c.prec());  // jjnote: temporary hfloat
        at = a;

	int firstq = 1;
	while ( 1 )
	{
	    if ( x&1 )  // odd
	    {
		if ( firstq )     // avoid multiplication by 1
		{
		    c = at;
		    firstq = 0;
		}
		else  mul(c,at,c);

		if ( x==1 )  break;
	    }

	    sqr(at,at);
	    x /= 2;
	}
    }

#ifdef  HF_PARANOIA
    jjassert( c.OK() );
#endif
}
// ========================== end POWER_GEQ_3 ==============================
