// -*- C++ -*-
//
// this file is included from:
// hfloat/examples/main.cc
// hfloat/testing/main.cc
//

#include <math.h>
#include <stdlib.h>  // atol()
#include <stdio.h>
#include <iostream.h>
#include <ctype.h>   // for isdigit()
#include <string.h>


#include "../src/fxt/mult/fxtmult.h"
#include "../src/include/hfloat.h"

#define  RADIX  (hfloat::radix())

#define  DEFAULT_LDN  10

void usage(char *argv0, int default_ldn, int radix)
{
    char *p = NULL, exename[100];
    p = strrchr(argv0, '\\');
    if (p == NULL)
	p = strrchr(argv0, '/');
    if (p == NULL)
	p = argv0-1;
    strcpy(exename, p+1);	 
    cout<<
	"\n " << exename << " - high-precision algorithms to compute pi and other constants."
	"\n Usage variants:"
        "\n 1. " << exename << " --help:                  - this help screen"
	"\n 2. " << exename << " w/o arguments:           - interactive use, follow command prompt." <<
	"\n 3. " << exename << " ldn alg radix resultfile - command line call " <<
        "\n      ldn: (default: " << default_ldn  << ") is the log_2 of the desired precision in LIMBs "
	"\n        a LIMB is the 'superdigit' used by hfloat internally (0..radix-1)"
        "\n        the resulting decimal precision is 2^ldn*log_10(radix))"
        "\n        e.g. ldn=11 and radix=1000 gives a precision of 6144 decimal digits"
	"\n      alg:   algorithm (see list below), default is 3 = Gauss-AGM "
	"\n      radix: best values: 10000 for decimal output (def), and 65536 "
	"\n             for hexadecimal output but any value in 2..65535 is possible too." <<
        "\n      resultfile: name of a file for the digits; def: no save"
        "\n"
        ; 
}
//================ end USAGE ====================

//Hae:
//================ begin manual_operating ========

#define DEFAULT_ALG  3 
#define DEFAULT_RADIX 10000

void manual_operating(char *pname)
{
   char buf[200];
   char *pbuf = buf; 
   size_t bufsize = sizeof(buf);
   int  ldn, digits, alg;
   char srx[100];
   ulong rx;
   char fname[100] = "";
   
   printf("pi.exe - high-precision algorithms to compute pi and other constants.\n");
   while(1) {
       APPLICATION_USAGE(pname);
       printf("\nEnter <digits> <algorithm> dec|hex|<radix> [resultfile]]\n");
       *buf = '\0'; digits = 1024; alg = DEFAULT_ALG; rx = DEFAULT_RADIX;
       *fname = '\0';
       cin.getline(pbuf, bufsize);
       strlwr(buf);
       int n = sscanf(buf, "%d %d %s %s", &digits, &alg, srx, fname);
       if (n == 0 || digits < 0 ) {  
	  cout << "Bye." << endl;
	  break;
	}
        if (digits < 256) 
            digits = 256; //Hae: smaller values result in SIG... or wrong results
        if (*srx == 'd' || *srx == 'h') 
                rx = *srx == 'd' ? 10000 : 65536;
        else 
                if (sscanf(srx, "%lu", &rx) == 0 || rx < 2 || rx > 65536)
	                rx = DEFAULT_RADIX;
        hfloat::radix(rx);
	hfloat::radix(rx); // Hae: don't know why but it works
        digits /= hfdata::rxbspw;
        ldn = 1+(long)floor(log10(digits-1) / log10(2));
        n = (ulong)1 << ldn; 
        hfloat::default_prec(n);
        DO_APPLICATION(n, alg, pname, fname);
   }
   return;
}
//================ end manual_operating ========

int main(int argc, char **argv)
{
    int ldn;
    ulong n;
    char fname[100] = "";

    if ( argc<=1 )  // no arg -> manual operating (Hae)
    {
        ldn = DEFAULT_LDN;   // default precision
        /* ask the user for arguments:
           Enter <digits> <alg> <radix> <fname>
                     |      |     |       |
                     |      |     |       ---- resulting file 
                     |      |     |
                     |      |     ------ dec | hex | 2..65536
                     |      ------------ one of the algorithm-codes
                     ------------------- # of dig's of the result
                                         will be trunc to next lower
                                         power of two.
        */
        manual_operating(argv[0]);
        return 0;
    }
   // cmd line args present: use original (joerg's) cmd line interface
   for (int k=0; argv[1][k]!=0; ++k)
   {
         if ( (argv[1][k]=='?') || (argv[1][k]=='h') || (argv[1][k]=='H') || argv[1][k] == '-')
         {
            usage(argv[0], DEFAULT_LDN, RADIX);

            APPLICATION_USAGE(argv[0]);

            exit(0);
	 }
    }

    ldn = atoi(argv[1]); // precision from arg

    if ( ldn<0 )  ldn = -ldn;

    if (ldn < 2) ldn = 2; 

    n = ((ulong)1<<ldn); 

    hfloat::default_prec(n);

    int arg2 = DEFAULT_ALG;
    // 2 or more args  => application dependent parameter:
    if(argc>2)  arg2 = atoi(argv[2]);

    int rx = RADIX;
    // 3 or more args  => user gave radix:
    if(argc>3)  
    {   // radix from arg3
        if (isdigit(*argv[3]))              rx = atoi(argv[3]); 
        else
           if (tolower(*argv[3]) == 'd')    rx = 10000;
           else
              if (tolower(*argv[3]) == 'h') rx = 65536;
    }
    hfloat::radix(rx);
//    hfloat::radix(rx); // Hae: don't know why, but it works

   // 4 or more args  => user gave result file name:
    if(argc>4)
      strcpy(fname, argv[4]);

   if(argc>5)  cerr<<"\n WARNING: excess argument(s) ignored ! ";

//------- call the big & mighty functions ------

    DO_APPLICATION(n,arg2,argv[0],fname);

//----------------------------------------------


//    hfdata::print_statistics(n);
//    fxtmult::print_statistics(n);

    cerr<<endl;

    return 0;
}
//===================== end MAIN =====================================
